/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.ProgressListener;
import cc.arduino.utils.FileHash;
import cc.arduino.utils.Progress;
import cc.arduino.utils.network.FileDownloader;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import processing.app.I18n;

public class DownloadableContributionsDownloader {
    private final File stagingFolder;

    public DownloadableContributionsDownloader(File _stagingFolder) {
        this.stagingFolder = _stagingFolder;
    }

    public File download(DownloadableContribution contribution, Progress progress, String statusText, ProgressListener progressListener) throws Exception {
        URL url = new URL(contribution.getUrl());
        Path outputFile = Paths.get(this.stagingFolder.getAbsolutePath(), contribution.getArchiveFileName());
        Files.createDirectories(this.stagingFolder.toPath(), new FileAttribute[0]);
        if (!this.hasChecksum(contribution) && Files.exists(outputFile, new LinkOption[0])) {
            Files.delete(outputFile);
        }
        if (!Files.isRegularFile(outputFile, LinkOption.NOFOLLOW_LINKS) || Files.size(outputFile) < contribution.getSize()) {
            this.download(url, outputFile.toFile(), progress, statusText, progressListener);
        }
        progress.setStatus(I18n.tr("Verifying archive integrity..."));
        progressListener.onProgress(progress);
        String checksum = contribution.getChecksum();
        if (this.hasChecksum(contribution)) {
            String algo = checksum.split(":")[0];
            if (!FileHash.hash(outputFile.toFile(), algo).equalsIgnoreCase(checksum)) {
                throw new Exception(I18n.tr("CRC doesn't match. File is corrupted."));
            }
        }
        contribution.setDownloaded(true);
        contribution.setDownloadedFile(outputFile.toFile());
        return outputFile.toFile();
    }

    private boolean hasChecksum(DownloadableContribution contribution) {
        String checksum = contribution.getChecksum();
        if (checksum == null || checksum.isEmpty()) {
            return false;
        }
        String algo = checksum.split(":")[0];
        return algo != null && !algo.isEmpty();
    }

    public void download(URL url, File tmpFile, Progress progress, String statusText, ProgressListener progressListener) throws Exception {
        FileDownloader downloader = new FileDownloader(url, tmpFile);
        downloader.addObserver((o, arg) -> {
            FileDownloader me = (FileDownloader)o;
            String msg = "";
            if (me.getDownloadSize() != null) {
                long downloaded = (me.getInitialSize() + me.getDownloaded()) / 1000L;
                long total = (me.getInitialSize() + me.getDownloadSize()) / 1000L;
                msg = I18n.format(I18n.tr("Downloaded {0}kb of {1}kb."), downloaded, total);
            }
            progress.setStatus(statusText + " " + msg);
            progress.setProgress(me.getProgress());
            progressListener.onProgress(progress);
        });
        downloader.download();
        if (!downloader.isCompleted()) {
            throw new Exception(I18n.format(I18n.tr("Error downloading {0}"), url), downloader.getError());
        }
    }
}

