/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.legacy.PConstants;

public class Platform {
    public void setLookAndFeel() throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public void init() throws Exception {
    }

    public File getSettingsFolder() throws Exception {
        File home = new File(System.getProperty("user.home"));
        File dataFolder = new File(home, ".arduino15");
        return dataFolder;
    }

    public File getDefaultSketchbookFolder() throws Exception {
        return null;
    }

    public void openURL(File folder, String url) throws Exception {
        if (!url.startsWith("file://./")) {
            this.openURL(url);
            return;
        }
        url = url.replaceAll("file://./", folder.getCanonicalFile().toURI().toASCIIString());
        this.openURL(url);
    }

    public void openURL(String url) throws Exception {
        String launcher = PreferencesData.get("launcher");
        if (launcher != null) {
            Runtime.getRuntime().exec(new String[]{launcher, url});
        } else {
            this.showLauncherWarning();
        }
    }

    public boolean openFolderAvailable() {
        return PreferencesData.get("launcher") != null;
    }

    public void openFolder(File file) throws Exception {
        String launcher = PreferencesData.get("launcher");
        if (launcher != null) {
            String folder = file.getAbsolutePath();
            Runtime.getRuntime().exec(new String[]{launcher, folder});
        } else {
            this.showLauncherWarning();
        }
    }

    private static void loadLib(File lib) {
        try {
            System.load(lib.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.out.println("Cannot load native library " + lib.getAbsolutePath());
            System.out.println("The program has terminated!");
            System.exit(1);
        }
    }

    private native String resolveDeviceAttachedToNative(String var1);

    private native String[] listSerialsNative();

    public String preListAllCandidateDevices() {
        return null;
    }

    public List<String> listSerials() {
        return new ArrayList<String>(Arrays.asList(this.listSerialsNative()));
    }

    public List<String> listSerialsNames() {
        LinkedList<String> list = new LinkedList<String>();
        for (String port : this.listSerialsNative()) {
            list.add(port.split("_")[0]);
        }
        return list;
    }

    public synchronized Map<String, Object> resolveDeviceByVendorIdProductId(String serial, Map<String, TargetPackage> packages) {
        String vid_pid_iSerial = this.resolveDeviceAttachedToNative(serial);
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    LinkedList vids = new LinkedList(board.getPreferences().subTree("vid", 1).values());
                    if (vids.isEmpty()) continue;
                    LinkedList pids = new LinkedList(board.getPreferences().subTree("pid", 1).values());
                    for (int i = 0; i < vids.size(); ++i) {
                        String vidPid = (String)vids.get(i) + "_" + (String)pids.get(i);
                        if (!vid_pid_iSerial.toUpperCase().contains(vidPid.toUpperCase())) continue;
                        HashMap<String, Object> boardData = new HashMap<String, Object>();
                        boardData.put("board", board);
                        boardData.put("vid", vids.get(i));
                        boardData.put("pid", pids.get(i));
                        boardData.put("iserial", vid_pid_iSerial.substring(vidPid.length() + 1));
                        return boardData;
                    }
                }
            }
        }
        return null;
    }

    public String resolveDeviceByBoardID(Map<String, TargetPackage> packages, String boardId) {
        assert (packages != null);
        assert (boardId != null);
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    if (!boardId.equals(board.getId())) continue;
                    return board.getName();
                }
            }
        }
        return null;
    }

    public String getName() {
        return PConstants.platformNames[0];
    }

    protected void showLauncherWarning() {
        BaseNoGui.showWarning(I18n.tr("No launcher available"), I18n.tr("Unspecified platform, no launcher available.\nTo enable opening URLs or folders, add a \n\"launcher=/path/to/app\" line to preferences.txt"), null);
    }

    public List<BoardPort> filterPorts(List<BoardPort> ports, boolean aBoolean) {
        return new LinkedList<BoardPort>(ports);
    }

    public void fixPrefsFilePermissions(File prefsFile) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{"chmod", "600", prefsFile.getAbsolutePath()}, null, null);
        process.waitFor();
    }

    public List<File> postInstallScripts(File folder) {
        LinkedList<File> scripts = new LinkedList<File>();
        scripts.add(new File(folder, "install_script.sh"));
        scripts.add(new File(folder, "post_install.sh"));
        return scripts;
    }

    public List<File> preUninstallScripts(File folder) {
        LinkedList<File> scripts = new LinkedList<File>();
        scripts.add(new File(folder, "pre_uninstall.sh"));
        return scripts;
    }

    public String getOsName() {
        return System.getProperty("os.name");
    }

    public String getOsArch() {
        return System.getProperty("os.arch");
    }

    public void symlink(String something, File somewhere) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{"ln", "-s", something, somewhere.getAbsolutePath()}, null, somewhere.getParentFile());
        process.waitFor();
    }

    public void link(File something, File somewhere) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{"ln", something.getAbsolutePath(), somewhere.getAbsolutePath()}, null, null);
        process.waitFor();
    }

    public void chmod(File file, int mode) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{"chmod", Integer.toOctalString(mode), file.getAbsolutePath()}, null, null);
        process.waitFor();
    }

    public void fixSettingsLocation() throws Exception {
    }

    static {
        Platform.loadLib(new File(BaseNoGui.getContentFile("lib"), System.mapLibraryName("listSerialsj")));
    }
}

