/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.SketchCode;

public class SketchData {
    public static final List<String> SKETCH_EXTENSIONS = Arrays.asList("ino", "pde");
    public static final List<String> OTHER_ALLOWED_EXTENSIONS = Arrays.asList("c", "cpp", "h", "hh", "hpp", "s");
    public static final List<String> EXTENSIONS = Stream.concat(SKETCH_EXTENSIONS.stream(), OTHER_ALLOWED_EXTENSIONS.stream()).collect(Collectors.toList());
    private File primaryFile;
    private File folder;
    private File dataFolder;
    private File codeFolder;
    private String name;
    private List<SketchCode> codes = new ArrayList<SketchCode>();
    private static final Comparator<SketchCode> CODE_DOCS_COMPARATOR = new Comparator<SketchCode>(){

        @Override
        public int compare(SketchCode x, SketchCode y) {
            return x.getFileName().compareTo(y.getFileName());
        }
    };

    SketchData(File file) {
        this.primaryFile = file;
        String mainFilename = this.primaryFile.getName();
        int suffixLength = this.getDefaultExtension().length() + 1;
        this.name = mainFilename.substring(0, mainFilename.length() - suffixLength);
        this.folder = new File(file.getParent());
    }

    public static File checkSketchFile(File file) {
        String fileName = file.getName();
        File parent = file.getParentFile();
        String parentName = parent.getName();
        String pdeName = parentName + ".pde";
        File altPdeFile = new File(parent, pdeName);
        String inoName = parentName + ".ino";
        File altInoFile = new File(parent, inoName);
        if (pdeName.equals(fileName) || inoName.equals(fileName)) {
            return file;
        }
        if (altPdeFile.exists()) {
            return altPdeFile;
        }
        if (altInoFile.exists()) {
            return altInoFile;
        }
        return null;
    }

    protected void load() throws IOException {
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        String[] list = this.folder.list();
        if (list == null) {
            throw new IOException("Unable to list files from " + this.folder);
        }
        this.clearCodeDocs();
        for (String filename : list) {
            if (filename.startsWith(".") || new File(this.folder, filename).isDirectory()) continue;
            String base = filename;
            for (String extension : EXTENSIONS) {
                if (!base.toLowerCase().endsWith("." + extension)) continue;
                if (BaseNoGui.isSanitaryName(base = base.substring(0, base.length() - (extension.length() + 1)))) {
                    this.addCode(new SketchCode(new File(this.folder, filename)));
                    continue;
                }
                System.err.println(I18n.format(I18n.tr("File name {0} is invalid: ignored"), filename));
            }
        }
        if (this.getCodeCount() == 0) {
            throw new IOException(I18n.tr("No valid code files found"));
        }
        for (SketchCode code : this.getCodes()) {
            if (!code.getFile().equals(this.primaryFile)) continue;
            this.moveCodeToFront(code);
            break;
        }
        this.sortCode();
    }

    public void save() throws IOException {
        for (SketchCode code : this.getCodes()) {
            if (!code.isModified()) continue;
            code.save();
        }
    }

    public int getCodeCount() {
        return this.codes.size();
    }

    public SketchCode[] getCodes() {
        return this.codes.toArray(new SketchCode[0]);
    }

    public String getDefaultExtension() {
        return "ino";
    }

    public File getPrimaryFile() {
        return this.primaryFile;
    }

    public String getMainFilePath() {
        return this.primaryFile.getAbsolutePath();
    }

    public void addCode(SketchCode sketchCode) {
        this.codes.add(sketchCode);
    }

    public void moveCodeToFront(SketchCode codeDoc) {
        this.codes.remove(codeDoc);
        this.codes.add(0, codeDoc);
    }

    protected void replaceCode(SketchCode newCode) {
        for (SketchCode code : this.codes) {
            if (!code.getFileName().equals(newCode.getFileName())) continue;
            this.codes.set(this.codes.indexOf(code), newCode);
            return;
        }
    }

    protected void sortCode() {
        if (this.codes.size() < 2) {
            return;
        }
        SketchCode first = this.codes.remove(0);
        Collections.sort(this.codes, CODE_DOCS_COMPARATOR);
        this.codes.add(0, first);
    }

    public SketchCode getCode(int i) {
        return this.codes.get(i);
    }

    protected void removeCode(SketchCode which) {
        for (SketchCode code : this.codes) {
            if (code != which) continue;
            this.codes.remove(code);
            return;
        }
        System.err.println("removeCode: internal error.. could not find code");
    }

    public int indexOfCode(SketchCode who) {
        for (SketchCode code : this.codes) {
            if (code != who) continue;
            return this.codes.indexOf(code);
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void clearCodeDocs() {
        this.codes.clear();
    }

    public File getFolder() {
        return this.folder;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public File getCodeFolder() {
        return this.codeFolder;
    }
}

