/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;

public class LegacyTargetBoard
implements TargetBoard {
    private final String id;
    private final PreferencesMap prefs;
    private Map<String, PreferencesMap> menuOptions = new LinkedHashMap<String, PreferencesMap>();
    private final TargetPlatform containerPlatform;

    public LegacyTargetBoard(String _id, PreferencesMap _prefs, TargetPlatform parent) {
        this.containerPlatform = parent;
        this.id = _id;
        this.prefs = new PreferencesMap(_prefs);
        PreferencesMap menus = this.prefs.firstLevelMap().get("menu");
        if (menus != null) {
            this.menuOptions = menus.firstLevelMap();
        }
        if (!this.prefs.containsKey("build.board")) {
            String board = this.containerPlatform.getId() + "_" + this.id;
            board = board.toUpperCase();
            this.prefs.put("build.board", board);
        }
    }

    @Override
    public String getName() {
        return (String)this.prefs.get("name");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PreferencesMap getPreferences() {
        return this.prefs;
    }

    @Override
    public boolean hasMenu(String menuId) {
        return this.menuOptions.containsKey(menuId);
    }

    @Override
    public PreferencesMap getMenuLabels(String menuId) {
        return this.menuOptions.get(menuId).topLevelMap();
    }

    @Override
    public String getMenuLabel(String menuId, String selectionId) {
        return (String)this.getMenuLabels(menuId).get(selectionId);
    }

    @Override
    public Set<String> getMenuIds() {
        return this.menuOptions.keySet();
    }

    @Override
    public PreferencesMap getMenuPreferences(String menuId, String selectionId) {
        return this.menuOptions.get(menuId).subTree(selectionId);
    }

    @Override
    public TargetPlatform getContainerPlatform() {
        return this.containerPlatform;
    }
}

