/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import cc.arduino.os.windows.FolderFinderInWindowsEnvVar;
import cc.arduino.os.windows.FolderFinderInWindowsRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import processing.app.legacy.PApplet;
import processing.app.legacy.PConstants;

public class Platform
extends processing.app.Platform {
    private File settingsFolder;
    private File defaultSketchbookFolder;

    @Override
    public void init() throws Exception {
        super.init();
        this.checkPath();
        this.recoverSettingsFolderPath();
        this.recoverDefaultSketchbookFolder();
    }

    private void recoverSettingsFolderPath() throws Exception {
        FolderFinderInWindowsRegistry findInUserShellFolders = new FolderFinderInWindowsRegistry(null, "Documents", "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User Shell Folders", "Local AppData");
        FolderFinderInWindowsRegistry findInShellFolders = new FolderFinderInWindowsRegistry(findInUserShellFolders, "Documents", "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Local AppData");
        Path path = findInShellFolders.find();
        this.settingsFolder = path.resolve("Arduino15").toFile();
    }

    private Path recoverOldSettingsFolderPath() throws Exception {
        FolderFinderInWindowsRegistry findInUserShellFolders = new FolderFinderInWindowsRegistry(null, "Documents", "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User Shell Folders", "AppData");
        FolderFinderInWindowsRegistry findInShellFolders = new FolderFinderInWindowsRegistry(findInUserShellFolders, "Documents", "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "AppData");
        Path path = findInShellFolders.find();
        return path.resolve("Arduino15");
    }

    private void recoverDefaultSketchbookFolder() throws Exception {
        FolderFinderInWindowsEnvVar findInUserProfile = new FolderFinderInWindowsEnvVar(null, "Documents", "USERPROFILE");
        FolderFinderInWindowsRegistry findInUserShellFolders = new FolderFinderInWindowsRegistry(findInUserProfile, "Documents", "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User Shell Folders", "Personal");
        FolderFinderInWindowsRegistry findInShellFolders = new FolderFinderInWindowsRegistry(findInUserShellFolders, "Documents", "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Personal");
        Path path = findInShellFolders.find();
        this.defaultSketchbookFolder = path.resolve("Arduino").toFile();
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split(path, File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        for (String item : pieces) {
            File directory;
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if (!(directory = new File(item)).exists() || item.trim().length() == 0) continue;
            legit[legitCount++] = item;
        }
        String newPath = PApplet.join(legit = PApplet.subset(legit, 0, legitCount), File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    @Override
    public File getSettingsFolder() {
        return this.settingsFolder;
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return this.defaultSketchbookFolder;
    }

    @Override
    public void openURL(String url) throws Exception {
        if (url.startsWith("http") || url.startsWith("file:")) {
            Runtime.getRuntime().exec("cmd /c start \"\" \"" + url + "\"");
        } else {
            Runtime.getRuntime().exec("cmd /c \"" + url + "\"");
        }
    }

    @Override
    public boolean openFolderAvailable() {
        return true;
    }

    @Override
    public void openFolder(File file) throws Exception {
        String folder = file.getAbsolutePath();
        Runtime.getRuntime().exec("explorer \"" + folder + "\"");
    }

    @Override
    public String getName() {
        return PConstants.platformNames[1];
    }

    @Override
    public void fixPrefsFilePermissions(File prefsFile) throws IOException {
    }

    @Override
    public List<File> postInstallScripts(File folder) {
        LinkedList<File> scripts = new LinkedList<File>();
        scripts.add(new File(folder, "post_install.bat"));
        return scripts;
    }

    @Override
    public List<File> preUninstallScripts(File folder) {
        LinkedList<File> scripts = new LinkedList<File>();
        scripts.add(new File(folder, "pre_uninstall.bat"));
        return scripts;
    }

    public void symlink(File something, File somewhere) throws IOException, InterruptedException {
    }

    @Override
    public void link(File something, File somewhere) throws IOException, InterruptedException {
    }

    @Override
    public void chmod(File file, int mode) throws IOException, InterruptedException {
    }

    @Override
    public void fixSettingsLocation() throws Exception {
        Path oldSettingsFolder = this.recoverOldSettingsFolderPath();
        if (!Files.exists(oldSettingsFolder, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(oldSettingsFolder.resolve(Paths.get("preferences.txt", new String[0])), new LinkOption[0])) {
            return;
        }
        if (this.settingsFolder.exists()) {
            return;
        }
        Files.move(oldSettingsFolder, this.settingsFolder.toPath(), new CopyOption[0]);
    }
}

