/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import processing.app.Theme;

public class SplashScreenHelper {
    private static final int X_OFFSET = 0;
    private static final int Y_OFFSET = 300;
    private static final int TEXTAREA_HEIGHT = 30;
    private static final int TEXTAREA_WIDTH = 475;
    private final Map desktopHints;
    private final SplashScreen splash;
    private Rectangle2D.Double splashTextArea;
    private Graphics2D splashGraphics;

    public SplashScreenHelper(SplashScreen splash) {
        this.splash = splash;
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.desktopHints = (Map)tk.getDesktopProperty("awt.font.desktophints");
    }

    public void splashText(String text) {
        if (this.splash == null) {
            this.printText(text);
            return;
        }
        if (!this.splash.isVisible()) {
            return;
        }
        if (this.splashTextArea == null) {
            this.prepareTextAreaAndGraphics();
        }
        this.eraseLastStatusText();
        this.drawText(text);
        this.ensureTextIsDiplayed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureTextIsDiplayed() {
        Class<SplashScreen> clazz = SplashScreen.class;
        synchronized (SplashScreen.class) {
            if (this.splash.isVisible()) {
                this.splash.update();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void drawText(String str) {
        this.splashGraphics.setPaint(Color.BLACK);
        FontMetrics metrics = this.splashGraphics.getFontMetrics();
        this.splashGraphics.drawString(str, (int)this.splashTextArea.getX() + 10, (int)this.splashTextArea.getY() + (30 - metrics.getHeight()) + 5);
    }

    private void eraseLastStatusText() {
        this.splashGraphics.setPaint(new Color(229, 229, 229));
        this.splashGraphics.fill(this.splashTextArea);
    }

    private void prepareTextAreaAndGraphics() {
        this.splashTextArea = new Rectangle2D.Double(0.0, 300.0, 475.0, 30.0);
        this.splashGraphics = Theme.setupGraphics2D(this.splash.createGraphics());
        if (this.desktopHints != null) {
            this.splashGraphics.addRenderingHints(this.desktopHints);
        }
    }

    public void close() {
        if (this.splash == null) {
            return;
        }
        this.splash.close();
    }

    private void printText(String str) {
        System.err.println(str);
    }
}

