/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Theme;
import processing.app.helpers.Keys;
import processing.app.helpers.OSUtils;
import processing.app.helpers.SimpleAction;
import processing.app.tools.MenuScroller;

public class EditorHeader
extends JComponent {
    static Color backgroundColor;
    static Color[] textColor;
    Editor editor;
    int[] tabLeft;
    int[] tabRight;
    Font font;
    FontMetrics metrics;
    int fontAscent;
    JMenu menu;
    JPopupMenu popup;
    int menuLeft;
    int menuRight;
    static final String[] STATUS;
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    static final String[] WHERE;
    static final int LEFT = 0;
    static final int MIDDLE = 1;
    static final int RIGHT = 2;
    static final int PIECE_WIDTH;
    static final int PIECE_HEIGHT;
    static final int GRID_SIZE = 33;
    static Image[][] pieces;
    static Image[] menuButtons;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    public Actions actions = new Actions();

    @Override
    public void addNotify() {
        super.addNotify();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            Keys.killFocusTraversalBinding(window, Keys.ctrl(9));
            Keys.killFocusTraversalBinding(window, Keys.ctrlShift(9));
        }
    }

    public EditorHeader(Editor eddie) {
        this.editor = eddie;
        if (pieces == null) {
            pieces = new Image[STATUS.length][WHERE.length];
            menuButtons = new Image[STATUS.length];
            for (int i = 0; i < STATUS.length; ++i) {
                for (int j = 0; j < WHERE.length; ++j) {
                    String path = "tab-" + STATUS[i] + "-" + WHERE[j];
                    EditorHeader.pieces[i][j] = Theme.getThemeImage(path, this, PIECE_WIDTH, PIECE_HEIGHT);
                }
                String path = "tab-" + STATUS[i] + "-menu";
                EditorHeader.menuButtons[i] = Theme.getThemeImage(path, this, PIECE_HEIGHT, PIECE_HEIGHT);
            }
        }
        if (backgroundColor == null) {
            backgroundColor = Theme.getColor("header.bgcolor");
            EditorHeader.textColor[1] = Theme.getColor("header.text.selected.color");
            EditorHeader.textColor[0] = Theme.getColor("header.text.unselected.color");
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (x > EditorHeader.this.menuLeft && x < EditorHeader.this.menuRight) {
                    EditorHeader.this.popup.show(EditorHeader.this, x, y);
                } else {
                    Sketch sketch = EditorHeader.this.editor.getSketch();
                    for (int i = 0; i < sketch.getCodeCount(); ++i) {
                        if (x <= EditorHeader.this.tabLeft[i] || x >= EditorHeader.this.tabRight[i]) continue;
                        sketch.setCurrentCode(i);
                        EditorHeader.this.repaint();
                    }
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics screen) {
        if (screen == null) {
            return;
        }
        Sketch sketch = this.editor.getSketch();
        if (sketch == null) {
            return;
        }
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            if (size.width > this.imageW || size.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = size.width;
                this.sizeH = size.height;
            }
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = this.createImage(this.imageW, this.imageH);
        }
        Graphics2D g = Theme.setupGraphics2D(this.offscreen.getGraphics());
        if (this.font == null) {
            this.font = Theme.getFont("header.text.font");
        }
        g.setFont(this.font);
        this.metrics = g.getFontMetrics();
        this.fontAscent = this.metrics.getAscent();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, this.imageW, this.imageH);
        int codeCount = sketch.getCodeCount();
        if (this.tabLeft == null || this.tabLeft.length < codeCount) {
            this.tabLeft = new int[codeCount];
            this.tabRight = new int[codeCount];
        }
        int x = Theme.scale(6);
        for (int i = 0; i < sketch.getCodeCount(); ++i) {
            SketchCode code = sketch.getCode(i);
            String codeName = code.isExtension(sketch.getHiddenExtensions()) ? code.getPrettyName() : code.getFileName();
            String text = "  " + codeName + (code.isModified() ? " \u00a7" : "  ");
            int textWidth = (int)this.font.getStringBounds(text, g.getFontRenderContext()).getWidth();
            int pieceCount = 2 + textWidth / PIECE_WIDTH;
            int pieceWidth = pieceCount * PIECE_WIDTH;
            int state = code == sketch.getCurrentCode() ? 1 : 0;
            g.drawImage(pieces[state][0], x, 0, null);
            int contentLeft = x += PIECE_WIDTH;
            this.tabLeft[i] = x;
            for (int j = 0; j < pieceCount; ++j) {
                g.drawImage(pieces[state][1], x, 0, null);
                x += PIECE_WIDTH;
            }
            this.tabRight[i] = x;
            int textLeft = contentLeft + (pieceWidth - textWidth) / 2;
            g.setColor(textColor[state]);
            int baseline = (this.sizeH + this.fontAscent) / 2;
            g.drawString(text, textLeft, baseline);
            g.drawImage(pieces[state][2], x, 0, null);
            x += PIECE_WIDTH - 1;
        }
        this.menuLeft = this.sizeW - (16 + menuButtons[0].getWidth(this));
        this.menuRight = this.sizeW - 16;
        g.drawImage(menuButtons[this.popup.isVisible() ? 1 : 0], this.menuLeft, 0, null);
        screen.drawImage(this.offscreen, 0, 0, null);
    }

    public void rebuild() {
        this.rebuildMenu();
        this.repaint();
        Toolkit.getDefaultToolkit().sync();
    }

    public void rebuildMenu() {
        if (this.menu != null) {
            this.menu.removeAll();
        } else {
            this.menu = new JMenu();
            MenuScroller.setScrollerFor(this.menu);
            this.popup = this.menu.getPopupMenu();
            this.popup.setLightWeightPopupEnabled(true);
        }
        this.menu.add(new JMenuItem(this.actions.newTab));
        this.menu.add(new JMenuItem(this.actions.renameTab));
        this.menu.add(new JMenuItem(this.actions.deleteTab));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.prevTab));
        this.menu.add(new JMenuItem(this.actions.nextTab));
        Sketch sketch = this.editor.getSketch();
        if (sketch != null) {
            this.menu.addSeparator();
            int i = 0;
            for (SketchCode code : sketch.getCodes()) {
                int index = i++;
                JMenuItem item = new JMenuItem(code.isExtension(new String[]{sketch.getDefaultExtension()}) ? code.getPrettyName() : code.getFileName());
                item.addActionListener(e -> this.editor.getSketch().setCurrentCode(index));
                this.menu.add(item);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = Theme.scale(new Dimension(300, 33));
        if (OSUtils.isMacOS()) {
            --size.height;
        }
        return size;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = Theme.scale(new Dimension(3000, 33));
        if (OSUtils.isMacOS()) {
            --size.height;
        }
        return size;
    }

    static {
        textColor = new Color[2];
        STATUS = new String[]{"unsel", "sel"};
        WHERE = new String[]{"left", "mid", "right"};
        PIECE_WIDTH = Theme.scale(4);
        PIECE_HEIGHT = Theme.scale(33);
    }

    public class Actions {
        public final Action newTab = new SimpleAction(I18n.tr((String)"New Tab"), Keys.ctrlShift(78), () -> EditorHeader.this.editor.getSketch().handleNewCode());
        public final Action renameTab = new SimpleAction(I18n.tr((String)"Rename"), () -> EditorHeader.this.editor.getSketch().handleRenameCode());
        public final Action deleteTab = new SimpleAction(I18n.tr((String)"Delete"), () -> {
            try {
                EditorHeader.this.editor.getSketch().handleDeleteCode();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        public final Action prevTab = new SimpleAction(I18n.tr((String)"Previous Tab"), Keys.ctrlAlt(37), () -> EditorHeader.this.editor.sketch.handlePrevCode());
        public final Action nextTab = new SimpleAction(I18n.tr((String)"Next Tab"), Keys.ctrlAlt(39), () -> EditorHeader.this.editor.sketch.handleNextCode());

        Actions() {
            Keys.bind(EditorHeader.this, this.newTab);
            Keys.bind(EditorHeader.this, this.prevTab);
            Keys.bind(EditorHeader.this, this.nextTab);
            Keys.bind(EditorHeader.this, this.prevTab, Keys.ctrlShift(9));
            Keys.bind(EditorHeader.this, this.nextTab, Keys.ctrl(9));
        }
    }
}

