/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.DigitalInputBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class DigitalInputPullBlock
extends DigitalInputBlock {
    public static final String ARDUBLOCK_DIGITAL_READ_INPUT_PULLUP_DEFINE = "void __ardublockDigitalInputPullup(int pinNumber)\n{\npinMode(pinNumber, INPUT);\ndigitalWrite(pinNumber, HIGH);\n}\n\n";

    public DigitalInputPullBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    protected String generateCodeUsingNumberBlock(TranslatorBlock translatorBlock) throws SocketNullException, SubroutineNotDeclaredException {
        String number = translatorBlock.toCode();
        this.translator.addInputPin(number.trim());
        this.translator.addSetupCommand("digitalWrite(" + number + ", HIGH);");
        return "";
    }

    protected String generateCodeUsingNonNumberBlock(TranslatorBlock translatorBlock) throws SocketNullException, SubroutineNotDeclaredException {
        this.translator.addDefinitionCommand(ARDUBLOCK_DIGITAL_READ_INPUT_PULLUP_DEFINE);
        this.translator.addSetupCommand("__ardublockDigitalInputPullup(" + translatorBlock.toCode() + ");");
        return "";
    }
}

