/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.panda;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;

public class PandaInputPortBlock
extends TranslatorBlock {
    public int[][] pinTable;

    public PandaInputPortBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[2];
        int[] nArray = new int[2];
        nArray[1] = 8;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{1, 9};
        nArrayArray[3] = new int[]{4, 10};
        this.pinTable = nArrayArray;
    }

    public String toCode() throws SocketNullException {
        String g_name = this.getTranslator().getBlock(this.blockId).getGenusName();
        String port_str = g_name.substring(7);
        int port = Integer.parseInt(port_str);
        int pin = this.pinTable[port][0];
        int led_pin = this.pinTable[port][1];
        this.translator.addSetupCommand("pinMode(" + pin + ", INPUT);");
        this.translator.addSetupCommand("pinMode(" + led_pin + ", OUTPUT);");
        this.translator.addSetupCommand("digitalWrite(" + led_pin + ", HIGH);");
        return "A" + pin;
    }
}

