/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.storage;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class EEPROMWriteLongBlock
extends TranslatorBlock {
    public EEPROMWriteLongBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        EEPROMWriteLongBlock.setupEEPROMEnvironment(this.translator);
        String ret = "eepromWriteLong( ";
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        ret = String.valueOf(ret) + tb.toCode();
        tb = this.getRequiredTranslatorBlockAtSocket(1);
        ret = "\t" + ret + " , " + tb.toCode() + " ) ;\n";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }

    private static void setupEEPROMEnvironment(Translator t) {
        t.addHeaderFile("EEPROM.h");
        t.addDefinitionCommand("/*******************************************************************\nA way to write unsigned longs (4 Bytes) to EEPROM \nEEPROM library natively supports only bytes. \nSome attempt to save time but note takes around 8ms to write a long \n*******************************************************************/\nvoid eepromWriteLong(int address, unsigned long value){\n\tunion u_tag {\n\t\tbyte b[4];        //assumes 4 bytes in an long\n\t\tunsigned long ULtime;\n\t} time;\n\ttime.ULtime=value;\n\t// Do some checking if !SLOW! EEPROM writes are actually needed\n\tEEPROM.write(address  , time.b[0]); //Very likely to change. Not worth checking\n\tEEPROM.write(address+1, time.b[1]); //Very likely to change. Not worth checking\n\tif (time.b[2] != EEPROM.read(address+2) ) EEPROM.write(address+2, time.b[2]); // Save time/W&T. Don't write unless changed\n\tif (time.b[3] != EEPROM.read(address+3) ) EEPROM.write(address+3, time.b[3]); // Save time/W&T. Don't write unless changed\n}\n");
    }
}

