/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.ts;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class Dht11Humidity
extends TranslatorBlock {
    public Dht11Humidity(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        String pinNumber = translatorBlock.toCode();
        String dht11Name = "dht11_pin_" + pinNumber;
        this.translator.addHeaderFile("DHT.h");
        this.translator.addDefinitionCommand("DHT " + dht11Name + "(" + pinNumber + ", 11);\n");
        this.translator.addSetupCommand(String.valueOf(dht11Name) + ".begin();\n");
        String ret = String.valueOf(dht11Name) + ".readHumidity()";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }
}

