/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.ts;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class Dht22Temperature
extends TranslatorBlock {
    public Dht22Temperature(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        String pinNumber = translatorBlock.toCode();
        String dht22Name = "dht22_pin_" + pinNumber;
        this.translator.addHeaderFile("DHT.h");
        this.translator.addDefinitionCommand("DHT " + dht22Name + "(" + pinNumber + ", 22);\n");
        this.translator.addSetupCommand(String.valueOf(dht22Name) + ".begin();\n");
        String ret = String.valueOf(dht22Name) + ".readTemperature()";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }
}

