/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.ts;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class DigitalTube
extends TranslatorBlock {
    public DigitalTube(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String clk = this.getRequiredTranslatorBlockAtSocket(0).toCode();
        String dio = this.getRequiredTranslatorBlockAtSocket(1).toCode();
        String display = this.getRequiredTranslatorBlockAtSocket(2).toCode();
        String points = this.getRequiredTranslatorBlockAtSocket(3).toCode();
        String displayName = "tm1637_pins_" + clk + dio;
        this.translator.addHeaderFile("TM1637.h");
        this.translator.addDefinitionCommand("TM1637 " + displayName + ";");
        this.translator.addSetupCommand(String.valueOf(displayName) + ".begin(" + clk + "," + dio + ");\n" + displayName + ".setBrightness(0x0f);\n");
        return String.valueOf(displayName) + ".showNumberDec(" + display + ", false, 4, 0, " + points + ");\n";
    }
}

