/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.ts;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class Driver_DRV8835
extends TranslatorBlock {
    public Driver_DRV8835(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String direction = this.getRequiredTranslatorBlockAtSocket(0).toCode();
        String leftSpeed = this.getRequiredTranslatorBlockAtSocket(1).toCode();
        String rightSpeed = this.getRequiredTranslatorBlockAtSocket(2).toCode();
        this.translator.addHeaderFile("DRV8835MotorShield.h");
        this.translator.addDefinitionCommand("DRV8835MotorShield drv8835MotorDriver;");
        String ret = "";
        if (direction.equals("FORWARD")) {
            ret = String.valueOf(ret) + "drv8835MotorDriver.flipM1(false);\n";
            ret = String.valueOf(ret) + "drv8835MotorDriver.flipM2(true);\n";
        } else if (direction.equals("BACKWARD")) {
            ret = String.valueOf(ret) + "drv8835MotorDriver.flipM1(true);\n";
            ret = String.valueOf(ret) + "drv8835MotorDriver.flipM2(false);\n";
        } else if (direction.equals("LEFT_TURN")) {
            ret = String.valueOf(ret) + "drv8835MotorDriver.flipM1(true);\n";
            ret = String.valueOf(ret) + "drv8835MotorDriver.flipM2(true);\n";
        } else if (direction.equals("RIGHT_TURN")) {
            ret = String.valueOf(ret) + "drv8835MotorDriver.flipM1(false);\n";
            ret = String.valueOf(ret) + "drv8835MotorDriver.flipM2(false);\n";
        }
        ret = String.valueOf(ret) + "drv8835MotorDriver.setSpeeds(" + leftSpeed + "," + rightSpeed + ");\n";
        return ret;
    }
}

