/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.ts;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class Driver_I2C
extends TranslatorBlock {
    public Driver_I2C(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String direction = this.getRequiredTranslatorBlockAtSocket(0).toCode();
        direction = "TSi2cMotorDriver::" + direction;
        String leftSpeed = this.getRequiredTranslatorBlockAtSocket(1).toCode();
        String rightSpeed = this.getRequiredTranslatorBlockAtSocket(2).toCode();
        String address = this.getRequiredTranslatorBlockAtSocket(3).toCode();
        this.translator.addHeaderFile("TSi2cMotorDriver.h");
        this.translator.addDefinitionCommand("TSi2cMotorDriver i2cMotorDriver;");
        this.translator.addSetupCommand("i2cMotorDriver.begin();");
        String ret = "i2cMotorDriver.setI2CAddress(" + address + ");\n";
        ret = String.valueOf(ret) + "i2cMotorDriver.MotorSpeedSetAB(" + leftSpeed + "," + rightSpeed + ");\n";
        ret = String.valueOf(ret) + "i2cMotorDriver.MotorDirectionSet(" + direction + ");\n";
        return ret;
    }
}

