/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.ts;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class Driver_Mini_V11
extends TranslatorBlock {
    public Driver_Mini_V11(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String direction = this.getRequiredTranslatorBlockAtSocket(0).toCode();
        String leftSpeed = this.getRequiredTranslatorBlockAtSocket(1).toCode();
        String rightSpeed = this.getRequiredTranslatorBlockAtSocket(2).toCode();
        this.translator.addHeaderFile("SparkFunMiniMoto.h");
        this.translator.addDefinitionCommand("MiniMoto drv8830Motor0(0xCA);");
        this.translator.addDefinitionCommand("MiniMoto drv8830Motor1(0xC0);");
        String ret = "";
        if (direction.equals("FORWARD")) {
            ret = String.valueOf(ret) + "drv8830Motor0.drive(map(" + leftSpeed + ",0, 1023, 0, -100));";
            ret = String.valueOf(ret) + "drv8830Motor1.drive(map(" + rightSpeed + ",0, 1023, 0, 100));";
        } else if (direction.equals("BACKWARD")) {
            ret = String.valueOf(ret) + "drv8830Motor0.drive(map(" + leftSpeed + ",0, 1023, 0, 100));";
            ret = String.valueOf(ret) + "drv8830Motor1.drive(map(" + rightSpeed + ",0, 1023, 0, -100));";
        } else if (direction.equals("LEFT_TURN")) {
            ret = String.valueOf(ret) + "drv8830Motor0.drive(map(" + leftSpeed + ",0, 1023, 0, 100));";
            ret = String.valueOf(ret) + "drv8830Motor1.drive(map(" + rightSpeed + ",0, 1023, 0, 100));";
        } else if (direction.equals("RIGHT_TURN")) {
            ret = String.valueOf(ret) + "drv8830Motor0.drive(map(" + leftSpeed + ",0, 1023, 0, -100));";
            ret = String.valueOf(ret) + "drv8830Motor1.drive(map(" + rightSpeed + ",0, 1023, 0, -100));";
        }
        return ret;
    }
}

