/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.ts;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class Driver_MotorShield
extends TranslatorBlock {
    public Driver_MotorShield(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String direction = this.getRequiredTranslatorBlockAtSocket(0).toCode();
        String leftSpeed = this.getRequiredTranslatorBlockAtSocket(1).toCode();
        String rightSpeed = this.getRequiredTranslatorBlockAtSocket(2).toCode();
        this.translator.addHeaderFile("TSMotorShield.h");
        this.translator.addDefinitionCommand("TSMotorShield motorShield;");
        this.translator.addSetupCommand("motorShield.init();\n");
        String ret = "";
        if (direction.equals("FORWARD")) {
            ret = String.valueOf(ret) + "motorShield.setDirection(HIGH, LOW);\n";
        } else if (direction.equals("BACKWARD")) {
            ret = String.valueOf(ret) + "motorShield.setDirection(LOW, HIGH);\n";
        } else if (direction.equals("LEFT_TURN")) {
            ret = String.valueOf(ret) + "motorShield.setDirection(LOW, LOW);\n";
        } else if (direction.equals("RIGHT_TURN")) {
            ret = String.valueOf(ret) + "motorShield.setDirection(HIGH, HIGH);\n";
        }
        ret = String.valueOf(ret) + "motorShield.setSpeed(" + leftSpeed + ", " + rightSpeed + ");\n";
        return ret;
    }
}

