/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.ts;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class LedStripBrightness
extends TranslatorBlock {
    public LedStripBrightness(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String pin = this.getRequiredTranslatorBlockAtSocket(0).toCode();
        String led_count = this.getRequiredTranslatorBlockAtSocket(1).toCode();
        String brightness = this.getRequiredTranslatorBlockAtSocket(2).toCode();
        String name = "ls_" + pin;
        this.translator.addHeaderFile("TSLedStrip.h");
        this.translator.addDefinitionCommand("TSLedStrip " + name + ";");
        this.translator.addSetupCommand(String.valueOf(name) + ".init(" + pin + "," + led_count + ");");
        String ret = String.valueOf(name) + ".mStrip->setBrightness(" + brightness + ");\n";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }
}

