/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.ts;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class LedStripPixel
extends TranslatorBlock {
    public LedStripPixel(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String pin = this.getRequiredTranslatorBlockAtSocket(0).toCode();
        String led_count = this.getRequiredTranslatorBlockAtSocket(1).toCode();
        String led_id = this.getRequiredTranslatorBlockAtSocket(2).toCode();
        String red = this.getRequiredTranslatorBlockAtSocket(3).toCode();
        String green = this.getRequiredTranslatorBlockAtSocket(4).toCode();
        String blue = this.getRequiredTranslatorBlockAtSocket(5).toCode();
        String name = "ls_" + pin;
        this.translator.addHeaderFile("TSLedStrip.h");
        this.translator.addDefinitionCommand("TSLedStrip " + name + ";");
        this.translator.addSetupCommand(String.valueOf(name) + ".init(" + pin + "," + led_count + ");");
        String ret = String.valueOf(name) + ".mStrip->setPixelColor(" + led_id + "," + red + "," + green + "," + blue + ");\n";
        ret = String.valueOf(ret) + name + ".mStrip->show();\n";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }
}

