/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.LinkRule;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceListener;

public class InfixRule
implements LinkRule,
WorkspaceListener {
    @Override
    public boolean canLink(Block block1, Block block2, BlockConnector socket1, BlockConnector socket2) {
        if (block1 == null || block2 == null || socket1 == null || socket2 == null) {
            return false;
        }
        Block parent = block1;
        BlockConnector psocket = socket1;
        Block child = block1.workspace.getEnv().getBlock(socket1.getBlockID());
        Block newblock = block2;
        BlockConnector nplug = socket2;
        if (child != null && !psocket.equals(parent.getAfterConnector()) && parent.getNumSockets() > 0 && psocket != null && nplug.equals(newblock.getPlug()) && newblock.hasPlug() && newblock.getNumSockets() > 0 && !newblock.getSocketAt(0).hasBlock() && newblock.getSocketAt(0).getKind().equals(psocket.getKind()) && child.hasPlug() && newblock.getPlug().getKind().equals(child.getPlug().getKind())) {
            return true;
        }
        parent = block2;
        psocket = socket2;
        child = block1.getWorkspace().getEnv().getBlock(socket2.getBlockID());
        newblock = block1;
        nplug = socket1;
        return child != null && !psocket.equals(parent.getAfterConnector()) && parent.getNumSockets() > 0 && psocket != null && nplug.equals(newblock.getPlug()) && newblock.hasPlug() && newblock.getNumSockets() > 0 && !newblock.getSocketAt(0).hasBlock() && newblock.getSocketAt(0).getKind().equals(psocket.getKind()) && child.hasPlug() && newblock.getPlug().getKind().equals(child.getPlug().getKind());
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void workspaceEventOccurred(WorkspaceEvent e) {
        if (e.getEventType() == 5) {
            BlockLink link = e.getSourceLink();
            if (link == null) {
                return;
            }
            Block oldchild = e.getWorkspace().getEnv().getBlock(link.getLastBlockID());
            if (this.invalidBlock(oldchild)) {
                return;
            }
            Block newchild = e.getWorkspace().getEnv().getBlock(link.getPlugBlockID());
            if (this.invalidBlock(newchild)) {
                return;
            }
            Block parent = e.getWorkspace().getEnv().getBlock(link.getSocketBlockID());
            if (this.invalidBlock(parent)) {
                return;
            }
            if (!oldchild.hasPlug()) {
                return;
            }
            if (!newchild.hasPlug()) {
                return;
            }
            Block newChildPlug = e.getWorkspace().getEnv().getBlock(newchild.getPlug().getBlockID());
            if (this.invalidBlock(newChildPlug)) {
                return;
            }
            if (newchild.getNumSockets() <= 0) {
                return;
            }
            BlockConnector newChildSocket = newchild.getSocketAt(0);
            if (newChildSocket == null) {
                return;
            }
            if (newChildSocket.hasBlock()) {
                return;
            }
            BlockLink link2 = BlockLink.getBlockLink(e.getWorkspace(), newchild, oldchild, newchild.getSocketAt(0), oldchild.getPlug());
            if (link2 == null) {
                throw new RuntimeException("Why is this null?");
            }
            if (link2 != null) {
                link2.connect();
            }
        }
    }

    private boolean invalidBlock(Block block) {
        if (block == null) {
            return true;
        }
        if (block.getBlockID() == null) {
            return true;
        }
        return block.getBlockID().equals(Block.NULL);
    }
}

