/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockStub;
import edu.mit.blocks.workspace.Workspace;

public class SLBlockProperties {
    private static Workspace workspace;
    public static final String YES = "yes";
    public static final String VM_COMMAND_NAME = "vm-cmd-name";
    public static final String CMD_EVAL_PROCEDURE = "eval-procedure";
    public static final String INLINE_ARG = "inline-arg";
    public static final String ASK_AGENT_ARG = "ask-arg";
    public static final String TYPE = "type";
    public static final String SCOPE = "scope";
    public static final String SCOPE_AGENT = "agent";
    public static final String SCOPE_GLOBAL = "global";
    public static final String SCOPE_PATCH = "patch";
    public static final String SCOPE_LOCAL = "local";
    public static final String BREED_NAME = "breed-name";
    public static final String INCLUDE_BREED = "include-breed";
    public static final String INCLUDE_BREED_SHAPE = "include-breed-shape";
    public static final String BOUNDING_MIN = "bounding-min";
    public static final String BOUNDING_MAX = "bounding-max";
    public static final String BOUNDING_VALUE = "bounding-value";
    public static final String STACK_TYPE = "stack-type";
    public static final String STACK_MONITOR = "monitor";
    public static final String STACK_SETUP = "setup";
    public static final String STACK_BREED = "breed";
    public static final String STACK_BREED_FOREVER = "breed-forever";
    public static final String SPECIAL_VAL = "special-value";
    public static final String KIND_CMD = "cmd";
    public static final String KIND_NUMBER = "number";
    public static final String KIND_STRING = "string";
    public static final String IS_MONITORABLE = "is-monitorable";
    public static final String IS_SETUP = "is-setup";
    public static final String IS_COLLISION = "is-collision";
    public static final String IS_MONITOR = "is-monitor";
    public static final String IS_SLIDER = "is-slider";
    public static final String IS_BAR_GRAPH = "is-bar-graph";
    public static final String IS_LINE_GRAPH = "is-line-graph";
    public static final String IS_TABLE = "is-table";
    public static final String IS_RUNTIME_BAR_GRAPH = "is-runtime-bar-graph";
    public static final String IS_RUNTIME_LINE_GRAPH = "is-runtime-line-graph";
    public static final String IS_RUNTIME_TABLE = "is-runtime-table";
    public static final String RUNTIME_TYPE = "runtime-type";
    public static final String HAS_RUNTIME_EQUIVALENT = "has-runtime-equiv";
    public static final String IS_SPECIAL_VAR = "is-special-variable";
    public static final String IS_OWNED_BY_BREED = "is-owned-by-breed";
    public static final String IS_BREED_SET_BY_CANVAS = "is-breed-set-by-canvas";

    public static boolean isCmd(String cmd, Block b) {
        return b != null && cmd.equals(b.getProperty(VM_COMMAND_NAME));
    }

    public static boolean isMonitor(Block b) {
        return b != null && STACK_MONITOR.equals(b.getProperty(STACK_TYPE));
    }

    public static boolean isProcedureCall(Block b) {
        return b != null && CMD_EVAL_PROCEDURE.equals(b.getProperty(VM_COMMAND_NAME)) && b instanceof BlockStub;
    }

    public static boolean isCollision(Long blockID) {
        return SLBlockProperties.hasProperty(workspace.getEnv().getBlock(blockID), IS_COLLISION);
    }

    public static boolean hasProperty(Block b, String prop) {
        return b != null && b.getProperty(prop) != null;
    }

    public static RuntimeType getRuntimeType(Block b) {
        return RuntimeType.getRuntime(b.getProperty(RUNTIME_TYPE));
    }

    public static int getInlineArg(Block b) {
        String inlineArg = b.getProperty(INLINE_ARG);
        return inlineArg == null ? -1 : Integer.parseInt(inlineArg);
    }

    public static Block getParent(Block b) {
        Block parent;
        if (b instanceof BlockStub && (parent = ((BlockStub)b).getParent()) != null && workspace.getEnv().getRenderableBlock(parent.getBlockID()).getParentWidget() != null) {
            return parent;
        }
        return null;
    }

    public static Long getTopBlockID(Long blockID) {
        if (blockID == null || Block.NULL.equals(blockID) || workspace.getEnv().getBlock(blockID) == null) {
            return null;
        }
        Block b = workspace.getEnv().getBlock(blockID);
        if (b.hasBeforeConnector()) {
            return SLBlockProperties.getTopBlockID(b.getBeforeBlockID());
        }
        if (b.hasPlug()) {
            return SLBlockProperties.getTopBlockID(b.getPlugBlockID());
        }
        if (b.isProcedureDeclBlock() || SLBlockProperties.hasProperty(b, IS_COLLISION)) {
            return blockID;
        }
        return SLBlockProperties.isForeverRunBlock(blockID) ? blockID : null;
    }

    public static boolean terminatesStack(Block b) {
        if (!b.getAfterBlockID().equals(Block.NULL)) {
            return false;
        }
        Block before = workspace.getEnv().getBlock(b.getBeforeBlockID());
        Long id = b.getBlockID();
        while (before != null) {
            if (!before.getAfterBlockID().equals(id)) {
                return SLBlockProperties.terminatesStack(before);
            }
            id = before.getBlockID();
            before = workspace.getEnv().getBlock(before.getBeforeBlockID());
        }
        return true;
    }

    public static boolean isForeverRunBlock(Long blockID) {
        if (blockID.equals(Block.NULL)) {
            return false;
        }
        RuntimeType rt = SLBlockProperties.getRuntimeType(workspace.getEnv().getBlock(blockID));
        return rt == RuntimeType.FOREVER || rt == RuntimeType.RUNFORSOMETIME || rt == RuntimeType.RUNONCE;
    }

    public static enum RuntimeType {
        FOREVER("forever"),
        RUNONCE("runonce"),
        RUNFORSOMETIME("runforsometime"),
        NULL_RUNTIME("");

        private final String myString;

        private RuntimeType(String s) {
            this.myString = s;
        }

        public String getString() {
            return this.myString;
        }

        public static RuntimeType getRuntime(String s) {
            RuntimeType[] runtimeTypeArray = RuntimeType.values();
            int n = runtimeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RuntimeType t = runtimeTypeArray[n2];
                if (t.myString.equals(s)) {
                    return t;
                }
                ++n2;
            }
            return NULL_RUNTIME;
        }
    }
}

