/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CColorChooser
extends CButton
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 328149080226L;
    public static final String COLOR_CHANGE = "color_change_property";
    private ColorPicker popup;
    private Color previousColor = null;

    public CColorChooser(Color color) {
        super(color, Color.gray, "RGB = 0,0,0");
        this.popup = new ColorPicker(color);
        this.popup.setPopupSize(200, 100);
        this.add(this.popup);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Color getColor() {
        return this.popup.getColor();
    }

    public void setColor(Color color) {
        this.previousColor = this.buttonColor;
        this.popup.setColor(color);
        this.buttonColor = this.popup.getColor();
        this.repaint();
        String colorText = "RGB = " + this.buttonColor.getRed() + ", " + this.buttonColor.getGreen() + ", " + this.buttonColor.getBlue();
        this.setText(colorText);
        this.firePropertyChange(COLOR_CHANGE, this.previousColor, this.buttonColor);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.popup.setVisible(false);
        String colorText = "RGB = " + this.buttonColor.getRed() + ", " + this.buttonColor.getGreen() + ", " + this.buttonColor.getBlue();
        this.setText(colorText);
        this.firePropertyChange(COLOR_CHANGE, this.previousColor, this.buttonColor);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.popup.mouseDragged(SwingUtilities.convertMouseEvent(this, e, this.popup));
        this.previousColor = this.buttonColor;
        this.buttonColor = this.popup.getColor();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.popup.show(this, e.getX(), e.getY());
    }

    public class ColorPicker
    extends JPopupMenu
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 328149080227L;
        private float WIDTH = 200.0f;
        private float HEIGHT = 100.0f;
        private float hue = 0.75f;
        private int mx = 0;
        private int my = 0;
        private Color color = null;
        private BufferedImage buffImg = null;

        public ColorPicker(Color color) {
            this.color = color;
            this.setBounds(0, 0, 500, 500);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public void paint(Graphics g) {
            if (this.buffImg == null) {
                this.buffImg = new BufferedImage(this.getWidth(), this.getHeight(), 6);
                Graphics gb = this.buffImg.getGraphics();
                int i = 0;
                while ((float)i <= this.WIDTH) {
                    int j = 0;
                    while ((float)j <= this.HEIGHT) {
                        gb.setColor(new Color(Color.HSBtoRGB((float)i / this.WIDTH, (float)j / this.HEIGHT, this.hue)));
                        gb.fillRect(i, j, 1, 1);
                        ++j;
                    }
                    ++i;
                }
            }
            g.drawImage(this.buffImg, 0, 0, null);
            g.setColor(Color.black);
            g.drawOval(this.mx - 2, this.my - 2, 2, 2);
            g.setColor(Color.white);
            g.drawOval(this.mx - 3, this.my - 3, 3, 3);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mx = e.getX() < 0 ? 0 : ((float)e.getX() > this.WIDTH ? (int)this.WIDTH : e.getX());
            this.my = e.getY() < 0 ? 0 : ((float)e.getY() > this.HEIGHT ? (int)this.HEIGHT : e.getY());
            int col = Color.HSBtoRGB((float)this.mx / this.WIDTH, (float)this.my / this.HEIGHT, this.hue);
            this.color = new Color(col);
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

