/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CArrowButton;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.GlassExplorer;
import edu.mit.blocks.codeblockutil.MagicExplorer;
import edu.mit.blocks.codeblockutil.PopupExplorer;
import edu.mit.blocks.codeblockutil.StackExplorer;
import edu.mit.blocks.codeblockutil.TabbedExplorer;
import edu.mit.blocks.codeblockutil.WindowExplorer;
import edu.mit.blocks.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public final class Navigator {
    private Type explorerModel;
    private int position;
    private List<Explorer> explorers;
    private JScrollPane scroll;
    private JComponent view;
    private ExplorerSwitcher switcher;
    private NavigationAnimator animator;
    private final Workspace workspace;

    public Navigator(Workspace workspace) {
        this(workspace, Type.GLASS);
    }

    public Navigator(Workspace workspace, Type UIModel) {
        this.workspace = workspace;
        this.explorerModel = UIModel;
        this.animator = new NavigationAnimator();
        this.explorers = new ArrayList<Explorer>();
        this.view = new JPanel();
        this.position = 0;
        this.view.setBackground(Color.GRAY);
        this.view.setLayout(new BorderLayout());
        ImageIcon logo = new ImageIcon(this.getClass().getResource("/edu/mit/blocks/logoTS.png"));
        JLabel logoLabel = new JLabel(logo);
        logoLabel.setVerticalAlignment(3);
        logoLabel.setHorizontalAlignment(2);
        this.view.add((Component)logoLabel, "South");
        this.scroll = new JScrollPane(this.view, 21, 31);
        this.switcher = new ExplorerSwitcher();
    }

    private void printError(String m) {
        System.err.println(m);
    }

    /*
     * WARNING - void declaration
     */
    public final void addExlorer(String name) {
        void var2_10;
        if (name == null) {
            this.printError("Name of explorer may not be assigned as null");
            return;
        }
        for (Explorer explorer : this.explorers) {
            if (!explorer.getName().equals(name)) continue;
            this.printError("May not add duplicate explorers named: " + name);
            return;
        }
        if (this.explorerModel == Type.GLASS) {
            GlassExplorer glassExplorer = new GlassExplorer(this.workspace);
        } else if (this.explorerModel == Type.MAGIC) {
            MagicExplorer magicExplorer = new MagicExplorer();
        } else if (this.explorerModel == Type.POPUP) {
            PopupExplorer popupExplorer = new PopupExplorer();
        } else if (this.explorerModel == Type.WINDOW) {
            WindowExplorer windowExplorer = new WindowExplorer();
        } else if (this.explorerModel == Type.TABBED) {
            TabbedExplorer tabbedExplorer = new TabbedExplorer();
        } else {
            StackExplorer stackExplorer = new StackExplorer();
        }
        var2_10.setName(name);
        this.explorers.add((Explorer)var2_10);
        this.view.add(var2_10.getJComponent());
        this.reformView();
    }

    public final void removeExplorer(String name) {
        if (name == null) {
            this.printError("Name of explorer may not be assigned as null");
            return;
        }
        Explorer explorer = null;
        for (Explorer ex : this.explorers) {
            if (!ex.getName().equals(name)) continue;
            if (explorer == null) {
                explorer = ex;
                continue;
            }
            this.printError("Navigator has duplicate explorers named: " + name);
            return;
        }
        if (explorer == null) {
            this.printError("Navigator does not have a explorer named: " + name);
            return;
        }
        this.explorers.remove(explorer);
        this.view.remove(explorer.getJComponent());
        this.reformView();
    }

    public List<Explorer> getExplorers() {
        return this.explorers;
    }

    public boolean hasExplorer(String name) {
        if (name == null) {
            return false;
        }
        for (Explorer explorer : this.explorers) {
            if (!explorer.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void reformView() {
        int accumWidth = 0;
        int height = this.scroll.getHeight();
        int width = this.scroll.getWidth();
        for (Explorer explorer : this.explorers) {
            explorer.getJComponent().setBounds(accumWidth, 0, width, height);
            explorer.reformView();
            accumWidth += width;
        }
        this.view.setPreferredSize(new Dimension(accumWidth, height));
        this.view.setBounds(0, 0, accumWidth, height);
        this.scroll.revalidate();
        this.scroll.repaint();
        this.scroll.getHorizontalScrollBar().setValue(this.explorers.get(this.position).getJComponent().getX());
    }

    public void setCanvas(List<? extends Canvas> canvases, String explorer) {
        for (Explorer ex : this.explorers) {
            if (!ex.getName().equals(explorer)) continue;
            ex.setDrawersCard(canvases);
        }
        this.reformView();
    }

    public void setView(String name) {
        int i = 0;
        while (i < this.explorers.size()) {
            Explorer ex = this.explorers.get(i);
            if (ex.getName().equals(name)) {
                this.setView(i);
            }
            ++i;
        }
    }

    private void setView(int index) {
        if (!this.explorers.isEmpty()) {
            int middlePosition = index < 0 ? this.explorers.size() - 1 : index;
            middlePosition = index >= this.explorers.size() ? 0 : middlePosition;
            int leftPosition = middlePosition - 1;
            int rightPosition = middlePosition + 1;
            if (leftPosition < 0) {
                leftPosition = this.explorers.size() - 1;
            }
            if (rightPosition > this.explorers.size() - 1) {
                rightPosition = 0;
            }
            this.position = middlePosition;
            this.switcher.switchView(this.explorers.get(leftPosition).getName(), this.explorers.get(this.position).getName(), this.explorers.get(rightPosition).getName());
            this.animator.start(this.explorers.get(this.position).getJComponent().getX());
        }
    }

    public JComponent getJComponent() {
        return this.scroll;
    }

    public JComponent getSwitcher() {
        return this.switcher;
    }

    private class ExplorerSwitcher
    extends JPanel {
        private static final long serialVersionUID = 328149080295L;
        private final int LABEL_HEIGHT = 9;
        private final Dimension ARROW_DIMENSION = new Dimension(16, 16);
        private JLabel mainLabel;
        private JLabel leftLabel = new JLabel("", 2);
        private CArrowButton leftArrow;
        private JLabel rightLabel;
        private CArrowButton rightArrow;

        private ExplorerSwitcher() {
            this.leftLabel.setForeground(Color.white);
            this.leftLabel.setFont(new Font("Arial", 0, 9));
            this.leftArrow = new CArrowButton(CArrowButton.Direction.WEST){
                private static final long serialVersionUID = 328149080296L;

                @Override
                public void triggerAction() {
                    Navigator.this.setView(Navigator.this.position - 1);
                }
            };
            this.leftArrow.setPreferredSize(this.ARROW_DIMENSION);
            this.rightLabel = new JLabel("", 4);
            this.rightLabel.setForeground(Color.white);
            this.rightLabel.setFont(new Font("Arial", 0, 9));
            this.rightArrow = new CArrowButton(CArrowButton.Direction.EAST){
                private static final long serialVersionUID = 328149080297L;

                @Override
                public void triggerAction() {
                    Navigator.this.setView(Navigator.this.position + 1);
                }
            };
            this.rightArrow.setPreferredSize(this.ARROW_DIMENSION);
            this.mainLabel = new JLabel("", 0);
            this.mainLabel.setFont(new Font("Arial", 1, 15));
            this.mainLabel.setForeground(Color.white);
            this.mainLabel.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            this.add((Component)this.leftArrow, gbc);
            ++gbc.gridx;
            gbc.gridheight = 2;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            this.add((Component)this.mainLabel, gbc);
            ++gbc.gridx;
            gbc.gridheight = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.add((Component)this.rightArrow, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.leftLabel, gbc);
            gbc.gridx += 2;
            this.add((Component)this.rightLabel, gbc);
        }

        void switchView(String left, String middle, String right) {
            this.leftLabel.setText(left);
            this.mainLabel.setText(middle);
            this.rightLabel.setText(right);
        }
    }

    private class NavigationAnimator
    implements ActionListener {
        private final int partitions = 10;
        private Timer timer = new Timer(50, this);
        private int value = 0;
        private int dx;
        private int count;

        private NavigationAnimator() {
        }

        private void start(int x) {
            this.count = 10;
            this.value = x;
            this.dx = (x - Navigator.this.scroll.getHorizontalScrollBar().getValue()) / 10;
            this.timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.count < 0) {
                this.timer.stop();
                Navigator.this.scroll.getHorizontalScrollBar().setValue(this.value);
                Navigator.this.scroll.revalidate();
                Navigator.this.scroll.repaint();
            } else {
                Navigator.this.scroll.getHorizontalScrollBar().setValue(this.value - this.dx * this.count);
                --this.count;
                Navigator.this.scroll.revalidate();
                Navigator.this.scroll.repaint();
            }
        }
    }

    public static enum Type {
        GLASS,
        MAGIC,
        POPUP,
        STACK,
        TABBED,
        WINDOW;

    }
}

