/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

public class NumberFormatter {
    public static final StandardPrecisionSpecifier LOW_PRECISION = new StandardPrecisionSpecifier(-2, 4, 3);
    public static final StandardPrecisionSpecifier MEDIUM_PRECISION = new StandardPrecisionSpecifier(-5, 7, 4);
    public static final StandardPrecisionSpecifier HIGH_PRECISION = new StandardPrecisionSpecifier(-5, 7, 6);
    public static final StandardPrecisionSpecifier VERY_LOW_PRECISION = new StandardPrecisionSpecifier(-6, 8, 8);
    private PrecisionSpecifier ps;
    private String eCharacter = "e";
    private boolean showZeroBeforeDecimal = true;
    private boolean showPlusInExponent = true;
    private boolean showExtraZeros = false;

    public NumberFormatter() {
        this.ps = MEDIUM_PRECISION;
    }

    public NumberFormatter(PrecisionSpecifier ps) {
        this.ps = ps;
    }

    public NumberFormatter(PrecisionSpecifier ps, char eCharacter, boolean showZeroBeforeDecimal, boolean showPlusInExponent, boolean showExtraZeros) {
        this(ps, "" + eCharacter, showZeroBeforeDecimal, showPlusInExponent, showExtraZeros);
    }

    public NumberFormatter(PrecisionSpecifier ps, String eCharacter, boolean showZeroBeforeDecimal, boolean showPlusInExponent, boolean showExtraZeros) {
        this.ps = ps;
        this.eCharacter = eCharacter;
        this.showZeroBeforeDecimal = showZeroBeforeDecimal;
        this.showPlusInExponent = showPlusInExponent;
        this.showExtraZeros = showExtraZeros;
    }

    public String format(double x) {
        if (x == 0.0) {
            return "0";
        }
        StringBuffer buf = new StringBuffer();
        if (x < 0.0) {
            buf.append('-');
            x = -x;
        }
        int p = (int)Math.floor(Math.log10(x));
        int d = Math.max(1, Math.min(14, this.ps.significantDigits(p)));
        long a = (long)(x * Math.pow(10.0, -p + d - 1));
        if (p < 0) {
            if (p >= this.ps.showAsDecimalThreshold()) {
                if (!this.showExtraZeros) {
                    while (a % 10L == 0L) {
                        a /= 10L;
                        --d;
                    }
                }
                String sigFigs = Long.toString(a);
                if (this.showZeroBeforeDecimal) {
                    buf.append('0');
                }
                buf.append('.');
                int i = -1;
                while (i > p) {
                    buf.append('0');
                    --i;
                }
                buf.append(sigFigs);
                return buf.toString();
            }
        } else if (d >= p + 1) {
            if (!this.showExtraZeros) {
                while (p + 1 < d && a % 10L == 0L) {
                    a /= 10L;
                    --d;
                }
            }
            String sigFigs = Long.toString(a);
            buf.append(sigFigs.substring(0, p + 1));
            if (p + 1 != d) {
                buf.append('.');
                buf.append(sigFigs.substring(p + 1, sigFigs.length()));
            }
            return buf.toString();
        }
        if (!this.showExtraZeros) {
            while (a % 10L == 0L) {
                a /= 10L;
                --d;
            }
        }
        String sigFigs = Long.toString(a);
        buf.append(sigFigs.charAt(0));
        buf.append('.');
        buf.append(sigFigs.substring(1, sigFigs.length()));
        buf.append(this.eCharacter);
        if (p > 0 && this.showPlusInExponent) {
            buf.append("+");
        }
        buf.append(Integer.toString(p));
        return buf.toString();
    }

    public static interface PrecisionSpecifier {
        public int significantDigits(int var1);

        public int showAsDecimalThreshold();
    }

    private static class StandardPrecisionSpecifier
    implements PrecisionSpecifier {
        private final int lowPrecisionThreshold;
        private final int highPrecisionThreshold;
        private final int desiredDigits;

        public StandardPrecisionSpecifier(int lowPrecisionThreshold, int highPrecisionThreshold, int desiredDigits) throws IllegalArgumentException {
            if (lowPrecisionThreshold > 0) {
                throw new IllegalArgumentException("Low precision threshold cannot be positive");
            }
            if (highPrecisionThreshold < 0) {
                throw new IllegalArgumentException("High precision threshold cannot be negaitive");
            }
            this.lowPrecisionThreshold = lowPrecisionThreshold;
            this.highPrecisionThreshold = highPrecisionThreshold;
            this.desiredDigits = desiredDigits;
        }

        @Override
        public int significantDigits(int precision) {
            if (Math.abs(precision) <= this.desiredDigits || precision > this.highPrecisionThreshold || precision < this.lowPrecisionThreshold) {
                return this.desiredDigits;
            }
            return precision;
        }

        @Override
        public int showAsDecimalThreshold() {
            return this.lowPrecisionThreshold;
        }
    }
}

