/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockStub;
import edu.mit.blocks.codeblockutil.CBorderlessButton;
import edu.mit.blocks.codeblockutil.CLabel;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.Navigator;
import edu.mit.blocks.renderable.FactoryRenderableBlock;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.FactoryCanvas;
import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.SearchableContainer;
import edu.mit.blocks.workspace.Subset;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceListener;
import edu.mit.blocks.workspace.WorkspaceWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FactoryManager
implements WorkspaceWidget,
ComponentListener,
WorkspaceListener {
    private static final String STATIC_NAME = "Factory";
    private static final String DYNAMIC_NAME = "My Blocks";
    private static final String SUBSETS_NAME = "Subsets";
    private Navigator navigator;
    private JComponent factorySwicther;
    private List<FactoryCanvas> staticCanvases;
    private List<FactoryCanvas> dynamicCanvases;
    private List<FactoryCanvas> subsetCanvases;
    private final Workspace workspace;

    public FactoryManager(Workspace workspace) {
        this.workspace = workspace;
        this.navigator = new Navigator(workspace);
        this.navigator.getJComponent().setPreferredSize(new Dimension(170, 600));
        this.navigator.addExlorer(STATIC_NAME);
        this.navigator.addExlorer(DYNAMIC_NAME);
        this.navigator.addExlorer(SUBSETS_NAME);
        this.factorySwicther = new JPanel(new BorderLayout());
        this.factorySwicther.add(this.navigator.getSwitcher());
        this.factorySwicther.setOpaque(false);
        this.navigator.getJComponent().addComponentListener(this);
        this.staticCanvases = new ArrayList<FactoryCanvas>();
        this.dynamicCanvases = new ArrayList<FactoryCanvas>();
        this.subsetCanvases = new ArrayList<FactoryCanvas>();
    }

    public void reset() {
        this.staticCanvases = new ArrayList<FactoryCanvas>();
        this.dynamicCanvases = new ArrayList<FactoryCanvas>();
        this.subsetCanvases = new ArrayList<FactoryCanvas>();
        this.navigator.setCanvas(this.staticCanvases, STATIC_NAME);
        this.navigator.setCanvas(this.dynamicCanvases, DYNAMIC_NAME);
        this.navigator.setCanvas(this.subsetCanvases, SUBSETS_NAME);
    }

    public void setupSubsets(Collection<Subset> subsets, boolean usingSys, boolean usingSubs) {
        if (usingSubs) {
            this.subsetCanvases.clear();
            for (Subset subset : subsets) {
                FactoryCanvas canvas = new FactoryCanvas(subset.getName(), subset.getColor());
                for (RenderableBlock frb : subset.getBlocks()) {
                    canvas.addBlock(frb);
                    this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, (WorkspaceWidget)this, frb.getBlockID(), 3));
                }
                canvas.layoutBlocks();
                this.subsetCanvases.add(canvas);
            }
            this.navigator.setCanvas(this.subsetCanvases, SUBSETS_NAME);
            if (usingSys) {
                this.factorySwicther.removeAll();
                this.factorySwicther.add(this.navigator.getSwitcher());
            } else {
                this.factorySwicther.removeAll();
                this.factorySwicther.add(new CLabel(SUBSETS_NAME));
            }
            this.viewSubsetsDrawers();
        } else if (usingSys) {
            this.factorySwicther.removeAll();
            final CBorderlessButton factoryButton = new CBorderlessButton(STATIC_NAME);
            final CBorderlessButton myblocksButton = new CBorderlessButton(DYNAMIC_NAME);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (factoryButton.equals(e.getSource())) {
                        FactoryManager.this.viewStaticDrawers();
                    } else if (myblocksButton.equals(e.getSource())) {
                        FactoryManager.this.viewDynamicDrawers();
                    }
                }
            };
            factoryButton.addActionListener(listener);
            myblocksButton.addActionListener(listener);
            this.factorySwicther.add((Component)factoryButton, "West");
            this.factorySwicther.add((Component)myblocksButton, "East");
            this.viewStaticDrawers();
        }
        this.factorySwicther.revalidate();
        this.factorySwicther.repaint();
    }

    private void printError(String m) {
        System.err.println(m);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.relayoutFactory();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private void relayoutFactory() {
        this.navigator.reformView();
    }

    public void relayoutBlocks() {
        for (FactoryCanvas canvas : this.staticCanvases) {
            canvas.layoutBlocks();
        }
        for (FactoryCanvas canvas : this.dynamicCanvases) {
            canvas.layoutBlocks();
        }
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    public Collection<SearchableContainer> getSearchableContainers() {
        HashSet<SearchableContainer> containers = new HashSet<SearchableContainer>();
        for (SearchableContainer searchableContainer : this.staticCanvases) {
            containers.add(searchableContainer);
        }
        for (SearchableContainer searchableContainer : this.dynamicCanvases) {
            containers.add(searchableContainer);
        }
        return containers;
    }

    public Collection<Subset> getSubsets() {
        ArrayList<Subset> subsets = new ArrayList<Subset>();
        for (FactoryCanvas subset : this.subsetCanvases) {
            ArrayList<RenderableBlock> blocks = subset.getBlocks();
            subsets.add(new Subset(subset.getName(), subset.getColor(), blocks));
        }
        return subsets;
    }

    public Collection<String> getStaticDrawers() {
        HashSet<String> drawers = new HashSet<String>();
        for (Canvas canvas : this.staticCanvases) {
            String name = canvas.getName();
            if (name == null) {
                this.printError("Drawer name may not be null");
                continue;
            }
            if (drawers.contains(name)) {
                this.printError("Duplicate Drawer name!");
                continue;
            }
            drawers.add(name);
        }
        return drawers;
    }

    public Collection<String> getDynamicDrawers() {
        HashSet<String> drawers = new HashSet<String>();
        for (Canvas canvas : this.dynamicCanvases) {
            String name = canvas.getName();
            if (name == null) {
                this.printError("Drawer name may not be null");
                continue;
            }
            if (drawers.contains(name)) {
                this.printError("Duplicate Drawer name!");
                continue;
            }
            drawers.add(name);
        }
        return drawers;
    }

    public void viewStaticDrawers() {
        this.navigator.setView(STATIC_NAME);
    }

    public void viewDynamicDrawers() {
        this.navigator.setView(DYNAMIC_NAME);
    }

    public void viewSubsetsDrawers() {
        this.navigator.setView(SUBSETS_NAME);
    }

    private boolean isValidDrawer(boolean sta, boolean dyn, String name, int position) {
        if (sta) {
            if (position < 0) {
                return false;
            }
            if (position > this.staticCanvases.size()) {
                return false;
            }
            for (Canvas canvas : this.staticCanvases) {
                if (!canvas.getName().equals(name)) continue;
                return false;
            }
        }
        if (dyn) {
            if (position < 0) {
                return false;
            }
            if (position > this.dynamicCanvases.size()) {
                return false;
            }
            for (Canvas canvas : this.dynamicCanvases) {
                if (!canvas.getName().equals(name)) continue;
                return false;
            }
        }
        return true;
    }

    public void addStaticDrawer(String name, Color color) {
        this.addStaticDrawer(name, this.staticCanvases.size(), color);
    }

    public void addStaticDrawer(String name, int position, Color color) {
        if (this.isValidDrawer(true, false, name, position)) {
            FactoryCanvas canvas = new FactoryCanvas(name, color);
            this.staticCanvases.add(position, canvas);
            this.navigator.setCanvas(this.staticCanvases, STATIC_NAME);
        } else {
            this.printError("Invalid Drawer: trying to add a drawer that already exists: " + name);
        }
    }

    public void addSubsetDrawer(String name, Color color) {
        this.addSubsetDrawer(name, this.subsetCanvases.size(), color);
    }

    public void addSubsetDrawer(String name, int position, Color color) {
        FactoryCanvas canvas = new FactoryCanvas(name, color);
        this.subsetCanvases.add(position, canvas);
        this.navigator.setCanvas(this.subsetCanvases, SUBSETS_NAME);
    }

    public void addDynamicDrawer(String name) {
        this.addDynamicDrawer(name, this.dynamicCanvases.size());
    }

    public void addDynamicDrawer(String name, int position) {
        if (this.isValidDrawer(false, true, name, position)) {
            FactoryCanvas canvas = new FactoryCanvas(name);
            this.dynamicCanvases.add(position, canvas);
            this.navigator.setCanvas(this.dynamicCanvases, DYNAMIC_NAME);
        } else {
            this.printError("Invalid Drawer: trying to add a drawer that already exists: " + name);
        }
    }

    public void renameStaticDrawer(String oldName, String newName) {
        if (oldName == null || newName == null) {
            this.printError("Drawers may not have a null instance for a name.");
            return;
        }
        for (FactoryCanvas duplicateCanvas : this.staticCanvases) {
            if (!duplicateCanvas.getName().equals(newName)) continue;
            this.printError("Drawer already exists with name: " + newName);
            return;
        }
        for (FactoryCanvas oldCanvas : this.staticCanvases) {
            if (!oldCanvas.getName().equals(oldName)) continue;
            oldCanvas.setName(newName);
            return;
        }
        this.printError("No Drawer was found with the name: " + oldName);
    }

    public void renameDynamicDrawer(String oldName, String newName) {
        if (oldName == null || newName == null) {
            this.printError("Drawers may not have a null instance for a name.");
            return;
        }
        for (FactoryCanvas duplicateCanvas : this.dynamicCanvases) {
            if (!duplicateCanvas.getName().equals(newName)) continue;
            this.printError("Drawer already exists with name: " + newName);
            return;
        }
        for (FactoryCanvas oldCanvas : this.dynamicCanvases) {
            if (!oldCanvas.getName().equals(oldName)) continue;
            oldCanvas.setName(newName);
            return;
        }
        this.printError("No Drawer was found with the name: " + oldName);
    }

    public void removeStaticDrawer(String name) {
        FactoryCanvas canvas = null;
        for (FactoryCanvas c : this.staticCanvases) {
            if (!c.getName().equals(name)) continue;
            canvas = c;
        }
        if (canvas != null) {
            this.staticCanvases.remove(canvas);
            this.navigator.setCanvas(this.staticCanvases, STATIC_NAME);
            return;
        }
        this.printError("No Drawer found with name: " + name);
    }

    public void removeDynamicDrawer(String name) {
        FactoryCanvas canvas = null;
        for (FactoryCanvas c : this.dynamicCanvases) {
            if (!c.getName().equals(name)) continue;
            canvas = c;
        }
        if (canvas != null) {
            this.dynamicCanvases.remove(canvas);
            this.navigator.setCanvas(this.dynamicCanvases, DYNAMIC_NAME);
            return;
        }
        this.printError("No Drawer found with name: " + name);
    }

    public Collection<RenderableBlock> getStaticBlocks(String name) {
        ArrayList<RenderableBlock> blocks = new ArrayList<RenderableBlock>();
        for (FactoryCanvas canvas : this.staticCanvases) {
            if (!canvas.getName().equals(name)) continue;
            blocks.addAll(canvas.getBlocks());
            return blocks;
        }
        this.printError("Drawer not found: " + name);
        return blocks;
    }

    public Collection<RenderableBlock> getDynamicBlocks(String name) {
        ArrayList<RenderableBlock> blocks = new ArrayList<RenderableBlock>();
        for (FactoryCanvas canvas : this.dynamicCanvases) {
            if (!canvas.getName().equals(name)) continue;
            blocks.addAll(canvas.getBlocks());
            return blocks;
        }
        this.printError("Drawer not found: " + name);
        return blocks;
    }

    public Collection<RenderableBlock> getBlocks() {
        ArrayList<RenderableBlock> blocks = new ArrayList<RenderableBlock>();
        for (FactoryCanvas canvas : this.staticCanvases) {
            blocks.addAll(canvas.getBlocks());
        }
        for (FactoryCanvas canvas : this.dynamicCanvases) {
            blocks.addAll(canvas.getBlocks());
        }
        return blocks;
    }

    public void addStaticBlock(RenderableBlock block, String drawer) {
        for (FactoryCanvas canvas : this.staticCanvases) {
            if (!canvas.getName().equals(drawer)) continue;
            if (block == null || Block.NULL.equals(block.getBlockID())) {
                this.printError("Attempting to add a null instance of block");
                return;
            }
            canvas.addBlock(block);
            this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, (WorkspaceWidget)this, block.getBlockID(), 3));
            canvas.layoutBlocks();
            return;
        }
        this.printError("Drawer not found: " + drawer);
    }

    public void addDynamicBlock(RenderableBlock block, String drawer) {
        for (FactoryCanvas canvas : this.dynamicCanvases) {
            if (!canvas.getName().equals(drawer)) continue;
            if (block == null || Block.NULL.equals(block.getBlockID())) {
                this.printError("Attempting to add a null instance of block");
                return;
            }
            canvas.addBlock(block);
            this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, (WorkspaceWidget)this, block.getBlockID(), 3));
            canvas.layoutBlocks();
            return;
        }
        this.printError("Drawer not found: " + drawer);
    }

    public void addStaticBlocks(Collection<RenderableBlock> blocks, String drawer) {
        for (FactoryCanvas canvas : this.staticCanvases) {
            if (!canvas.getName().equals(drawer)) continue;
            for (RenderableBlock block : blocks) {
                if (block == null || Block.NULL.equals(block.getBlockID())) continue;
                canvas.addBlock(block);
                this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, (WorkspaceWidget)this, block.getBlockID(), 3));
            }
            canvas.layoutBlocks();
            return;
        }
        this.printError("Drawer not found: " + drawer);
    }

    public void addDynamicBlocks(Collection<RenderableBlock> blocks, String drawer) {
        for (FactoryCanvas canvas : this.dynamicCanvases) {
            if (!canvas.getName().equals(drawer)) continue;
            for (RenderableBlock block : blocks) {
                if (block == null || Block.NULL.equals(block.getBlockID())) continue;
                canvas.addBlock(block);
                this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, (WorkspaceWidget)this, block.getBlockID(), 3));
            }
            canvas.layoutBlocks();
            return;
        }
        this.printError("Drawer not found: " + drawer);
    }

    public void addSubsetBlocks(Collection<RenderableBlock> blocks, String drawerName) {
        for (FactoryCanvas canvas : this.subsetCanvases) {
            if (!canvas.getName().equals(drawerName)) continue;
            for (RenderableBlock block : blocks) {
                if (block == null || Block.NULL.equals(block.getBlockID())) continue;
                canvas.addBlock(block);
                this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, (WorkspaceWidget)this, block.getBlockID(), 3));
            }
            canvas.layoutBlocks();
            return;
        }
        this.printError("Drawer not found: " + drawerName);
    }

    public void removeStaticBlock(RenderableBlock block, String drawer) {
        for (FactoryCanvas canvas : this.staticCanvases) {
            if (!canvas.getName().equals(drawer)) continue;
            canvas.removeBlock(block);
            canvas.layoutBlocks();
            return;
        }
        this.printError("Drawer not found: " + drawer);
    }

    public void removeDynamicBlock(RenderableBlock block, String drawer) {
        for (FactoryCanvas canvas : this.dynamicCanvases) {
            if (!canvas.getName().equals(drawer)) continue;
            canvas.removeBlock(block);
            canvas.layoutBlocks();
            return;
        }
        this.printError("Drawer not found: " + drawer);
    }

    @Override
    public void blockEntered(RenderableBlock block) {
    }

    @Override
    public void blockExited(RenderableBlock block) {
    }

    @Override
    public void blockDragged(RenderableBlock block) {
    }

    @Override
    public void removeBlock(RenderableBlock block) {
    }

    @Override
    public void addBlock(RenderableBlock block) {
    }

    @Override
    public void addBlocks(Collection<RenderableBlock> blocks) {
    }

    @Override
    public void blockDropped(RenderableBlock block) {
        Container parent;
        WorkspaceWidget oldParent = block.getParentWidget();
        if (oldParent != null) {
            oldParent.removeBlock(block);
        }
        if ((parent = block.getParent()) != null) {
            parent.remove(block);
            parent.validate();
            parent.repaint();
            block.setParentWidget(null);
        }
        this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, (WorkspaceWidget)this, block.getBlockID(), 4));
    }

    @Override
    public JComponent getJComponent() {
        return this.navigator.getJComponent();
    }

    public JComponent getFactorySwitcher() {
        return this.factorySwicther;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.navigator.getJComponent().contains(x, y);
    }

    private String staticdrawer(BlockStub stub) {
        for (FactoryCanvas canvas : this.staticCanvases) {
            for (RenderableBlock bl : canvas.getBlocks()) {
                if (!bl.getGenus().equals(stub.getParentGenus())) continue;
                return canvas.getName();
            }
        }
        return null;
    }

    @Override
    public void workspaceEventOccurred(WorkspaceEvent event) {
        if (event.getEventType() == 3) {
            if (event.getSourceWidget() instanceof Page) {
                Page page = (Page)event.getSourceWidget();
                Block block = this.workspace.getEnv().getBlock(event.getSourceBlockID());
                if (block.hasStubs()) {
                    for (BlockStub stub : block.getFreshStubs()) {
                        this.addStaticBlock(new FactoryRenderableBlock(event.getWorkspace(), this, stub.getBlockID()), this.staticdrawer(stub));
                    }
                }
            }
        } else if (event.getEventType() == 4) {
            Block block = this.workspace.getEnv().getBlock(event.getSourceBlockID());
            if (block.hasStubs()) {
                for (Long stub : BlockStub.getStubsOfParent(event.getWorkspace(), block)) {
                    RenderableBlock rb = this.workspace.getEnv().getRenderableBlock(stub);
                    if (rb == null || rb.getBlockID().equals(Block.NULL) || rb.getParentWidget() == null || !rb.getParentWidget().equals(this)) continue;
                    rb.getParent().remove(rb);
                    rb.setParentWidget(null);
                }
            }
            this.relayoutBlocks();
        } else if (event.getEventType() == 11) {
            Block block = this.workspace.getEnv().getBlock(event.getSourceBlockID());
            if (block != null && block.hasStubs()) {
                for (Long stub : BlockStub.getStubsOfParent(event.getWorkspace(), block)) {
                    RenderableBlock rb = this.workspace.getEnv().getRenderableBlock(stub);
                    if (rb == null || rb.getBlockID().equals(Block.NULL) || rb.getParentWidget() == null || !rb.getParentWidget().equals(this)) continue;
                    rb.getParent().remove(rb);
                    rb.setParentWidget(null);
                }
                this.relayoutBlocks();
            }
        } else {
            event.getEventType();
        }
    }

    public String toString() {
        return "FactoryManager: " + this.navigator.getJComponent();
    }
}

