/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.renderable.Comment;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.BlockCanvas;
import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.PageChangeEventManager;
import edu.mit.blocks.workspace.PageChangeListener;
import edu.mit.blocks.workspace.PageDivider;
import edu.mit.blocks.workspace.SearchableContainer;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MiniMap
extends JPanel
implements WorkspaceWidget,
MouseListener,
MouseMotionListener,
SearchableContainer,
PageChangeListener {
    private static final long serialVersionUID = 328149080271L;
    private static final int BORDER_WIDTH = 5;
    private static final int DEFAULT_WIDTH = 150;
    private static final int DEFAULT_HEIGHT = 75;
    private int MAPWIDTH = 150;
    private int MAPHEIGHT = 75;
    private BlockCanvas blockCanvas;
    private boolean expand = false;
    private final MiniMapEnlargerTimer enlarger;
    private double transformX = 1.0;
    private double transformY = 1.0;
    private final Workspace workspace;

    public MiniMap(Workspace workspace) {
        this.workspace = workspace;
        this.setPreferredSize(new Dimension(this.MAPHEIGHT, this.MAPHEIGHT));
        this.setLayout(null);
        this.setOpaque(false);
        this.setFont(new Font("Ariel", 0, 9));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.enlarger = new MiniMapEnlargerTimer();
        PageChangeEventManager.addPageChangeListener(this);
    }

    public void hideMiniMap() {
        this.setSize(0, 0);
        this.setPreferredSize(new Dimension(0, 0));
        this.setVisible(false);
    }

    @Override
    public void update() {
        this.repaint();
    }

    public Iterable<RenderableBlock> getSearchableElements() {
        return new ArrayList<RenderableBlock>();
    }

    @Override
    public void updateContainsSearchResults(boolean containsSearchResults) {
        this.repaint();
    }

    public void repositionMiniMap() {
        if (this.getParent() != null) {
            this.setBounds(this.getParent().getWidth() - this.MAPWIDTH - 26, 0, this.MAPWIDTH + 10, this.MAPHEIGHT + 10);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int i = 0;
        while (i < 5) {
            g.setColor(new Color(200, 200, 150, 50 * (i + 1)));
            g.drawRect(i, i, this.getWidth() - 1 - 2 * i, this.getHeight() - 1 - 2 * i);
            ++i;
        }
        this.blockCanvas = this.workspace.getBlockCanvas();
        this.transformX = (double)this.MAPWIDTH / (double)this.getCanvas().getWidth();
        this.transformY = (double)this.MAPHEIGHT / (double)this.getCanvas().getHeight();
        g.translate(5, 5);
        for (Page page : this.blockCanvas.getPages()) {
            Color pageColor = page.getPageColor();
            g.setColor(new Color(pageColor.getRed(), pageColor.getGreen(), pageColor.getBlue(), 200));
            Rectangle pageRect = this.rescaleRect(page.getJComponent().getBounds());
            g.fillRect(pageRect.x, pageRect.y, pageRect.width, pageRect.height);
            g.setColor(Color.white);
            g.clipRect(pageRect.x, pageRect.y, pageRect.width, pageRect.height);
            if (page.getIcon() != null && this.expand) {
                g.drawImage(page.getIcon(), pageRect.x + 1, pageRect.height - 28, 15, 15, null);
            }
            g.setClip(null);
            Component[] componentArray = page.getJComponent().getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component instanceof RenderableBlock && component != null && component.isVisible()) {
                    if (((RenderableBlock)component).isSearchResult()) {
                        g.setColor(Color.yellow);
                    } else {
                        g.setColor(((RenderableBlock)component).getBLockColor());
                    }
                    this.drawBoundingBox(g, component);
                } else if (component instanceof Comment && component.isVisible()) {
                    g.setColor(Color.yellow);
                    this.drawBoundingBox(g, component);
                }
                ++n2;
            }
        }
        Component[] componentArray = this.getCanvas().getComponents();
        int n = componentArray.length;
        int n3 = 0;
        while (n3 < n) {
            Component component = componentArray[n3];
            if (component instanceof PageDivider) {
                g.setColor(Color.GRAY);
                Rectangle dividerRect = this.rescaleRect(component.getBounds());
                g.fillRect(dividerRect.x, dividerRect.y, dividerRect.width + 1, dividerRect.height);
            }
            ++n3;
        }
        componentArray = this.workspace.getComponentsInLayer(Workspace.DRAGGED_BLOCK_LAYER);
        n = componentArray.length;
        n3 = 0;
        while (n3 < n) {
            Component component = componentArray[n3];
            if (component instanceof RenderableBlock && component != null && component.isVisible()) {
                g.setColor(((RenderableBlock)component).getBLockColor());
                this.drawBoundingBox(g, component);
            } else if (component instanceof Comment && component.isVisible()) {
                g.setColor(Color.yellow);
                this.drawBoundingBox(g, component);
            }
            ++n3;
        }
        g.setColor(Color.red);
        g.drawRect(this.rescaleX(this.blockCanvas.getHorizontalModel().getValue()), this.rescaleY(this.blockCanvas.getVerticalModel().getValue()), this.rescaleX(this.blockCanvas.getWidth()), this.rescaleY(this.blockCanvas.getHeight()));
    }

    private void drawBoundingBox(Graphics g, Component block) {
        Rectangle blockRect = block.getBounds();
        blockRect.setLocation(SwingUtilities.convertPoint(block.getParent(), blockRect.getLocation(), this.getCanvas()));
        blockRect = this.rescaleRect(blockRect);
        g.fillRect(blockRect.x, blockRect.y, blockRect.width, blockRect.height);
        g.setColor(Color.white);
        g.drawRect(blockRect.x, blockRect.y, blockRect.width, blockRect.height);
    }

    private JComponent getCanvas() {
        return this.blockCanvas.getCanvas();
    }

    private int rescaleX(int x) {
        return (int)((double)x * this.transformX);
    }

    private int rescaleY(int y) {
        return (int)((double)y * this.transformY);
    }

    private Rectangle rescaleRect(Rectangle rec) {
        return new Rectangle((int)((double)rec.x * this.transformX), (int)((double)rec.y * this.transformY), (int)((double)rec.width * this.transformX), (int)((double)rec.height * this.transformY));
    }

    private Point rescaleToWorld(Point p) {
        Point point = new Point((int)((double)p.x / this.transformX), (int)((double)p.y / this.transformY));
        return point;
    }

    private void scrollToPoint(Point p) {
        Point transform = this.rescaleToWorld(p);
        this.blockCanvas.getHorizontalModel().setValue((int)((double)transform.x - 0.5 * (double)this.blockCanvas.getWidth()));
        this.blockCanvas.getVerticalModel().setValue((int)((double)transform.y - 0.5 * (double)this.blockCanvas.getHeight()));
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.scrollToPoint(e.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.scrollToPoint(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.expand = true;
        this.enlarger.expand();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.expand = false;
        this.enlarger.shrink();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void blockDragged(RenderableBlock block, Point WorkspacePoint) {
        Point mapPoint = SwingUtilities.convertPoint(block, WorkspacePoint, this);
        mapPoint.translate(-6, -6);
        Point worldPoint = SwingUtilities.convertPoint(this.getCanvas(), this.rescaleToWorld(mapPoint), this.workspace);
        int width = block.getStackBounds().width + 3;
        int height = block.getStackBounds().height + 3;
        int canvasWidth = this.getCanvas().getWidth() - this.workspace.getCanvasOffset().width;
        int canvasHeight = this.getCanvas().getHeight() - this.workspace.getCanvasOffset().height;
        if (worldPoint.y + height > canvasHeight) {
            worldPoint.setLocation(worldPoint.x, canvasHeight - height);
        }
        if (worldPoint.x + width > canvasWidth) {
            worldPoint.setLocation(canvasWidth - width, worldPoint.y);
        }
        block.setLocation(worldPoint);
        block.getDragHandler().myLoc.setLocation(worldPoint);
        block.moveConnectedBlocks();
        this.repaint();
    }

    @Override
    public void blockDropped(RenderableBlock block) {
        Point location = block.getLocation();
        if (location.getY() <= 0.0) {
            location.setLocation(location.getX(), 1.0);
        }
        WorkspaceWidget w = this.workspace.getWidgetAt(location);
        for (Page page : this.blockCanvas.getPages()) {
            if (!page.contains(SwingUtilities.convertPoint(block.getParent(), location, page.getJComponent()))) continue;
            w = page;
        }
        for (BlockConnector con : this.workspace.getEnv().getBlock(block.getBlockID()).getSockets()) {
            RenderableBlock socketBlock = block.getWorkspace().getEnv().getRenderableBlock(con.getBlockID());
            if (socketBlock == null) continue;
            w = socketBlock.getParentWidget();
        }
        w.blockDropped(block);
        this.repaint();
    }

    @Override
    public void blockEntered(RenderableBlock block) {
    }

    @Override
    public void blockExited(RenderableBlock block) {
    }

    @Override
    public void blockDragged(RenderableBlock block) {
    }

    @Override
    public void addBlock(RenderableBlock block) {
    }

    @Override
    public void addBlocks(Collection<RenderableBlock> blocks) {
    }

    @Override
    public void removeBlock(RenderableBlock block) {
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public boolean contains(int x, int y) {
        return new Rectangle(7, 7, this.getWidth() - 15, this.getHeight() - 15).contains(x, y);
    }

    public Collection<RenderableBlock> getBlocks() {
        return new ArrayList<RenderableBlock>();
    }

    public void animateAutoCenter(RenderableBlock block) {
        MiniMapAutoCenterTimer timer = new MiniMapAutoCenterTimer(block);
        timer.start();
    }

    private class MiniMapAutoCenterTimer
    implements ActionListener {
        private Timer timer = new Timer(5, this);
        private int count = 25;
        private int dx;
        private int dy;

        public MiniMapAutoCenterTimer(RenderableBlock block) {
            Point blockPosition = SwingUtilities.convertPoint(block, new Point((int)(block.getStackBounds().getWidth() / 2.0), (int)(block.getStackBounds().getHeight() / 2.0)), MiniMap.this.getCanvas());
            this.dx = (blockPosition.x - (MiniMap.this.blockCanvas.getHorizontalModel().getValue() + MiniMap.this.blockCanvas.getWidth() / 2)) / this.count;
            this.dy = (blockPosition.y - (MiniMap.this.blockCanvas.getVerticalModel().getValue() + MiniMap.this.blockCanvas.getHeight() / 2)) / this.count;
        }

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.count < 0) {
                this.timer.stop();
            } else {
                MiniMap.this.blockCanvas.getHorizontalModel().setValue(MiniMap.this.blockCanvas.getHorizontalModel().getValue() + this.dx);
                MiniMap.this.blockCanvas.getVerticalModel().setValue(MiniMap.this.blockCanvas.getVerticalModel().getValue() + this.dy);
                --this.count;
            }
        }
    }

    private class MiniMapEnlargerTimer
    implements ActionListener {
        private int count = 0;
        private Timer timer = new Timer(10, this);
        private int dx = 15;
        private int dy = 7;
        private boolean expand = true;
        private Timer delayTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniMapEnlargerTimer.this.delayTimer.stop();
                MiniMapEnlargerTimer.this.timer.start();
            }
        });

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.count <= 0 || this.count > 15) {
                this.timer.stop();
            } else {
                this.count = this.expand ? ++this.count : --this.count;
                MiniMap.this.MAPWIDTH = 150 + this.count * this.dx;
                MiniMap.this.MAPHEIGHT = 75 + this.count * this.dy;
                MiniMap.this.repositionMiniMap();
                MiniMap.this.repaint();
            }
        }

        public void expand() {
            this.expand = true;
            ++this.count;
            this.timer.start();
        }

        public void shrink() {
            --this.count;
            this.expand = false;
            this.delayTimer.start();
        }
    }
}

