#ifndef TSGESTURE_H
#define TSGESTURE_H

#define GES_REACTION_TIME       500 // You can adjust the reaction time according to the actual circumstance.
#define GES_ENTRY_TIME          800 // When you want to recognize the Forward/Backward gestures, your gestures' reaction time must less than GES_ENTRY_TIME(0.8s).
#define GES_QUIT_TIME           1000

#include <paj7620.h>

class TSGesture
{
  public:
    TSGesture()
    {
      paj7620Init();
    }

    int detect()
    {
      uint8_t data = 0, data1 = 0, error;

      error = paj7620ReadReg(0x43, 1, &data);             // Read Bank_0_Reg_0x43/0x44 for gesture result.

      if (!error)
      {
        switch (data)                                   // When different gestures be detected, the variable 'data' will be set to different values by paj7620ReadReg(0x43, 1, &data).
        {
          case GES_RIGHT_FLAG:
            delay(GES_ENTRY_TIME);
            paj7620ReadReg(0x43, 1, &data);
            if (data == GES_FORWARD_FLAG)
            {
              delay(GES_QUIT_TIME);
              return 4;//forward
            }
            else if (data == GES_BACKWARD_FLAG)
            {
              delay(GES_QUIT_TIME);
              return 5;//backward
            }
            else
            {
              return 0;//right
            }
            break;
          case GES_LEFT_FLAG:
            delay(GES_ENTRY_TIME);
            paj7620ReadReg(0x43, 1, &data);
            if (data == GES_FORWARD_FLAG)
            {
              delay(GES_QUIT_TIME);
              return 4;//forward
            }
            else if (data == GES_BACKWARD_FLAG)
            {
              delay(GES_QUIT_TIME);
              return 5;//backward
            }
            else
            {
              return 1;//right
            }
            break;
          case GES_UP_FLAG:
            delay(GES_ENTRY_TIME);
            paj7620ReadReg(0x43, 1, &data);
            if (data == GES_FORWARD_FLAG)
            {
              delay(GES_QUIT_TIME);
              return 4;//forward
            }
            else if (data == GES_BACKWARD_FLAG)
            {
              delay(GES_QUIT_TIME);
              return 5;//backward
            }
            else
            {
              return 2;//up
            }
            break;
          case GES_DOWN_FLAG:
            delay(GES_ENTRY_TIME);
            paj7620ReadReg(0x43, 1, &data);
            if (data == GES_FORWARD_FLAG)
            {
              delay(GES_QUIT_TIME);
              return 4;//forward
            }
            else if (data == GES_BACKWARD_FLAG)
            {
              delay(GES_QUIT_TIME);
              return 5;//backward
            }
            else
            {
              return 3;//down
            }
            break;
          case GES_FORWARD_FLAG:
            delay(GES_QUIT_TIME);
            return 4;//forward
            break;
          case GES_BACKWARD_FLAG:
            delay(GES_QUIT_TIME);
            return 5;//backward
            break;
          case GES_CLOCKWISE_FLAG:
            delay(GES_QUIT_TIME);
            return 6;//clockwise
            break;
          case GES_COUNT_CLOCKWISE_FLAG:
            delay(GES_QUIT_TIME);
            return 7;//anti-clockwise
            break;
          default:
            paj7620ReadReg(0x44, 1, &data1);
            if (data1 == GES_WAVE_FLAG)
            {
              return 8; //wave
            }
            break;
        }
        return -1;
      }
    }
};

#endif