#ifndef TSKEYPAD_H
#define TSKEYPAD_H

#include <Keypad.h>

const byte ROWS = 4; //four rows
const byte COLS = 3; //four columns

//define the symbols on the buttons of the keypads
const char hexaKeys[ROWS][COLS] = {
  {'1','2','3'},
  {'4','5','6'},
  {'7','8','9'},
  {'*','0','#'}
};

class TSKeypad
{
  public:
  Keypad *pad;

  byte rowPins[ROWS];
  byte colPins[COLS];
    
  TSKeypad(byte startPin)
  {
    rowPins[0] = startPin;
    rowPins[1] = startPin+1;
    rowPins[2] = startPin+2;
    rowPins[3] = startPin+3;
    colPins[0] = startPin+4;
    colPins[1] = startPin+5;
    colPins[2] = startPin+6;
    pad = new Keypad( makeKeymap(hexaKeys), rowPins, colPins, ROWS, COLS);
  }
  
  ~TSKeypad()
  {
    delete pad;
  }
  
  char getKey()
  {
    return pad->getKey();
  }
};

#endif