/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#ifndef TSLedBar_H
#define TSLedBar_H

#include <Grove_LED_Bar.h>

class TSLedBar : public Grove_LED_Bar
{
	public:
	TSLedBar(unsigned char pinClock, unsigned char pinData, bool greenToRed) : Grove_LED_Bar(pinClock, pinData, greenToRed){;}
	void setLevel(int value, int min, int max)
	{
		constrain(value, min, max);
		float ret = (value - min) * (10.0f - 0.0f) / (max - min) + 0.0f;//map() float implementation
		Grove_LED_Bar::setLevel(ret);
	}
};

#endif