/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#ifndef TSMotorShield_H
#define TSMotorShield_H

class TSMotorShield
{
  public:
  const byte directionA = 12;
  const byte directionB = 13;
  const byte speedA = 3;
  const byte speedB = 11;
  const byte brakeA = 9;
  const byte brakeB = 8;

  void init()
  {
    pinMode(directionA, OUTPUT);
    pinMode(directionB, OUTPUT);
    pinMode(speedA, OUTPUT);
    pinMode(speedB, OUTPUT);
    pinMode(brakeA, OUTPUT);
    pinMode(brakeB, OUTPUT);
    digitalWrite(brakeA, LOW);
    digitalWrite(brakeB, LOW);
  }
  
  void setDirection(byte a, byte b)
  {
    digitalWrite(directionA, a);
    digitalWrite(directionB, b);
  }
  
  void setSpeed(byte a, byte b)
  {  
    analogWrite(speedA, a);
    analogWrite(speedB, b);
  }
};

#endif
