/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#include "TSNetwork.h"
const long postingInterval = 16000L;
  
TSNetwork::TSNetwork():mEthernet(0),mWifi(0),mSerial(0)
{
  mLastConnectionTime=0L;
}

void TSNetwork::initEthernet(byte* mac)
{
  if(Ethernet.begin(mac))
  {
    Serial.println(Ethernet.localIP());
    mEthernet = new EthernetClient;
  }
}

void TSNetwork::initWifi(byte rx, byte tx, const char *ssid, const char *pass)
{
  mSerial = new SoftwareSerial(rx, tx);
  mSerial->begin(115200);
  mWifi = new ESP8266wifi(*mSerial, *mSerial, 30);
  mWifi->connectToAP(ssid, pass);
}

bool TSNetwork::connect(byte* ipAddress)
{
	if(mWifi && mSerial)
	{
		String cmd = "AT+CIPSTART=\"TCP\",\"";
    //Ip from byte[4] to char[]
		cmd += ipAddress[0];
    cmd += '.';
    cmd += ipAddress[1];
    cmd += '.';
    cmd += ipAddress[2];
    cmd += '.';
    cmd += ipAddress[3];
		cmd += "\",80";
		mSerial->println(cmd);
		if(mSerial->find("Error"))
		{
			return false;
		}
    return true;
  }
  else if(mEthernet)
  {
    // close any connection before send a new request.
    // This will free the socket on the WiFi shield
    mEthernet->stop();
    if (mEthernet->connect(ipAddress, 80))
    {
      return true;
    }
  }
  return false;
}

void TSNetwork::sendThingSpeak(const char * apiKey, float val1, float val2, float val3, float val4)
{
  if (millis() - mLastConnectionTime < postingInterval)
  {
    /*Serial.print(millis());
    Serial.print(" ");
    Serial.println(mLastConnectionTime);*/
    return;
  }
  
  mLastConnectionTime=millis();
  
  //Open a connection to ThingSpeak
  byte ip[] = {184, 106, 153, 149};
	if(!connect(ip)) return;
  
  // prepare GET string
  String getStr = "GET /update?api_key=";
  getStr += apiKey;
  getStr +="&field1=";
  getStr += val1;
  getStr +="&field2=";
  getStr += val2;
  getStr +="&field3=";
  getStr += val3;
  getStr +="&field4=";
  getStr += val4;
  if(mEthernet)
  {
    getStr += " HTTP/1.0";
  }
  if(mWifi)
  {
    getStr += "\r\n";
  }
  
  //Don't remove this line : mandatory for ESP8266wifi, don't know why
  Serial.println(getStr);
  
  if(mWifi && mSerial)
  {
    // send data length
    String cmd = "AT+CIPSEND=";
    cmd += String(getStr.length());
    mSerial->println(cmd);
    
    //Send command if prompted or close de connection
    if(mSerial->find(">"))
    {   
      mSerial->println(getStr);
    }
    else
    {
      mSerial->println("AT+CIPCLOSE");
    }
  }
  else if(mEthernet)
  {
    mEthernet->println(getStr);
    mEthernet->println();
  }
}