/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#ifndef TSNetwork_H
#define TSNetwork_H

#include <ESP8266wifi.h>
#include <Ethernet.h>
#include <SoftwareSerial.h>

class TSNetwork
{
	public:
	TSNetwork();
	void initEthernet(byte* mac);
	void initWifi(byte rx, byte tx, const char *ssid, const char *pass);
	bool connect(byte* ip);
	void sendThingSpeak(const char * apiKey, float val1=0.0f, float val2=0.0f, float val3=0.0f, float val4=0.0f);
	
	private:
	ESP8266wifi *mWifi;
  SoftwareSerial *mSerial;
	EthernetClient *mEthernet;
  unsigned long mLastConnectionTime;
};

#endif