/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#ifndef TSRFID_H
#define TSRFID_H

#include "TSSerial.h"

class TSRFID: public TSSerial
{
  public:
  TSRFID(){;}
  
  String readTag(byte rx, byte tx)
  {
    String raw = TSSerial::receive(rx, tx);
    if(raw.length()>=14)
    {
      //Checksum check
      byte data[6];
      data[0] = hex2dec(raw.substring(1,3));
      data[1] = hex2dec(raw.substring(3,5));
      data[2] = hex2dec(raw.substring(5,7));
      data[3] = hex2dec(raw.substring(7,9));
      data[4] = hex2dec(raw.substring(9,11));
      data[5] = hex2dec(raw.substring(11,13));
      if((data[0] ^ data[1] ^ data[2] ^ data[3] ^ data[4]) == data[5])
      {
        return String(hex2dec(raw.substring(3,11)));
      }
    }
    return "";
  }
  
  static long hex2dec(String hexCode)
  {
    char buf[19] = "";
    hexCode.toCharArray(buf, 18);
    return strtol(buf, NULL, 16);
  }
};

#endif
