/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#ifndef TSHeartRate_H
#define TSHeartRate_H

const byte max_count = 5;
volatile unsigned long pulsations[max_count] = { 0,0,0,0,0 };
volatile unsigned long last_beat = 0;
byte index = 0;

void heartPulseISR()
{
  unsigned long temp = millis();
  if(temp - last_beat > 2000)
  {
    last_beat = temp;
    return;
  }
  pulsations[index] = temp - last_beat;
  last_beat = temp;
  index++;
  if (index >= max_count)
  {
    index = 0;
  }
}

float getHeartRate()
{
  int sum = 0;
  byte c = 0;
  for (byte i = 0; i < max_count; i++)
  {
    if (pulsations[i] > 0)
    {
      c++;
      sum += pulsations[i];
    }
  }
  if (c > 0 && sum > 0)
    return 60000.0f / (sum / c);
  else
    return 0.0f;
}

#endif
