/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#include "TSSerial.h"
  
TSSerial::TSSerial():mSerial(0),mTx(0), mRx(0)
{
}

void TSSerial::init(byte rx, byte tx, unsigned long speed=9600)
{
  if(mSerial) delete mSerial;
  mRx = rx;
  mTx = tx;
  mSerial = new SoftwareSerial(mRx, mTx);
  mSerial->begin(speed);
  mSerial->setTimeout(100);
}

void TSSerial::send(byte rx, byte tx, String data)
{
  if(!mSerial) init(rx, tx);
  mSerial->print(data);
}

String TSSerial::receive(byte rx, byte tx)
{
  if(!mSerial) init(rx, tx);
  if(mSerial->available())
  {
    return mSerial->readString();
  }
  return String("");
}
byte TSSerial::receive()
{
  if(mSerial && mSerial->available())
  {
    return mSerial->read();
  }
  return 0;
}