/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#ifndef TSServo_H
#define TSServo_H

#include <Servo.h>

class TSServo : public Servo
{
	public:
	TSServo():Servo(){mTrim=0;;}

  void write(int value, int speed, int min, int max)
	{
		int finalValue = map(constrain(value, min, max), 0, 1023, 544, 2400);
		int currentValue = Servo::readMicroseconds();
		int	delta	= finalValue - currentValue;
    float increment = (float)speed/1000;
    //Synchronous move
		if(delta>0)
    {
			for(float i=0; i<=delta;i+=increment)
      {
					Servo::writeMicroseconds(currentValue+i);
			}
    }
    else
    {
			for(float i=0; i>=delta;i-=increment)
      {
					Servo::writeMicroseconds(currentValue+i);
			}
		}
    Servo::writeMicroseconds(finalValue);
  }
  
    void write_deg(int value, int speed, int min, int max)
    {
        min = constrain(min, 0, 180);
        max = constrain(max, 0, 180);
        int finalValue = map(constrain(value, min, max), 0, 180, 544, 2400);
        int currentValue = Servo::readMicroseconds();
        int	delta	= finalValue - currentValue;
        float increment = (float)speed/1000;
        //Synchronous move
        if(delta>0)
        {
            for(float i=0; i<=delta;i+=increment)
            {
                Servo::writeMicroseconds(currentValue+i);
            }
        }
        else
        {
            for(float i=0; i>=delta;i-=increment)
            {
                Servo::writeMicroseconds(currentValue+i);
            }
        }
        Servo::writeMicroseconds(finalValue);
    }
  
  
  void write(int value, bool inverse)
	{
    value = constrain(value, 0, 1023);
		int val = map(value, 0, 1023, 0, 90);
    mAngle = (float)val * ((float) value / 1023);
    int temp = 90+(inverse?-mAngle:mAngle)+mTrim;
    Servo::write(temp);
  }
    
  void setTrim(short trim)
  {
    mTrim=trim;
  }
  
  private:
  float mAngle;
  short mTrim;
};

#endif