/*
*Library Technologie Services
* Copyright © 2016 by Technologie Services. All rights reserved
Version 1
<http://www.technologieservices.fr>
*/

#ifndef TSTemperature_H
#define TSTemperature_H

#include <math.h>

/*
value = voltage
R = Zero power resistance
B = B constant
*/
float getTemperature(int value, const float R, const int B)
{
  float resistance=(float)(1023-value)*R/value;
  float temperature=1.0f/(log(resistance/R)/B+1/298.15)-273.15;
  return temperature;
}

#endif