% Fichier d'initialisation
% Obtient le nom du fichier modle
fichier=get_param(gcs,'Name');
if isempty(fichier), error('Erreur dans le nom du systme');return,end;
%%
% Configuration simulation
set_param(fichier,'StopTime','inf');
set_param(fichier,'MaxStep','0.05');
set_param(fichier,'Solver','ode45');
% Rendre la P.O. virtuelle visible durant la simulation
set_param(fichier,'VisDuringSimulation','On');
%%
fichier=strcat(fichier,'/');
%%
%Initialisation des paramtres du bloc ALIMENTATION
nom_block=strcat(fichier,'ALIMENTATION');
% Tension batterie
set_param(nom_block,'Ubat','12');
%%
%Initialisation des paramtres du bloc MOTEUR
nom_block=strcat(fichier,'MOTEUR');
% Vitesse Nominale 
set_param(nom_block,'Nn','3700');
% Tension Nominale
set_param(nom_block,'Un','12');
%%
%Initialisation des paramtres du bloc REDUCTEUR
% Rapport rduction 
nom_block=strcat(fichier,'REDUCTEUR');
% Nombre de dents Z1
set_param(nom_block,'Z1','20');
% Nombre de dents Z2
set_param(nom_block,'Z2','44');
%%
%Initialisation des paramtres du bloc TEL
nom_block=strcat(fichier,'TEL');
set_param(nom_block,'TEL','0');
%%
%Initialisation des paramtres du bloc VEH
nom_block=strcat(fichier,'VEH');
set_param(nom_block,'VEH','0');
%%
% Efface les variables inutiles
clear fichier
clear nom_block
% Tlcommande
TEL;
% Dtection Vhicule
DetVeh;
